/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.gsm;

import org.apache.log4j.Logger;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.SignalingProcessor;
import org.tritonus.lowlevel.gsm.GSMDecoder;
import org.tritonus.lowlevel.gsm.InvalidGSMFrameException;

public class Decoder
implements Codec {
    private transient Logger logger = Logger.getLogger(Decoder.class);
    private GSMDecoder decoder = new GSMDecoder();
    private static final int BUFFER_SIZE = 320;
    private byte[] m_abBuffer;

    public void process(Buffer buffer) {
        byte[] data = buffer.getData();
        byte[] res = this.process(data);
        buffer.setData(res);
        buffer.setOffset(0);
        buffer.setLength(res.length);
        buffer.setFormat((Format)Codec.LINEAR_AUDIO);
    }

    public byte[] process(byte[] media) {
        this.m_abBuffer = new byte[320];
        try {
            this.decoder.decode(media, 0, this.m_abBuffer, 0, false);
        }
        catch (InvalidGSMFrameException e) {
            e.printStackTrace();
        }
        return this.m_abBuffer;
    }

    public Format getSupportedInputFormat() {
        return Codec.GSM;
    }

    public Format getSupportedOutputFormat() {
        return Codec.LINEAR_AUDIO;
    }

    public void setProc(SignalingProcessor processor) {
    }
}

