/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.Inlet;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.AbstractSourceSet;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.TimerTask;

public class Demultiplexer
extends AbstractSourceSet
implements Inlet {
    private Format[] outputFormats = new Format[0];
    private Input input = null;
    private Buffer buff;
    private long timestamp;

    public Demultiplexer(String name) {
        super(name);
        this.input = new Input(name);
    }

    public AbstractSink getInput() {
        return this.input;
    }

    public void connect(MediaSource source) {
        this.input.connect(source);
    }

    public void disconnect(MediaSource source) {
        this.input.disconnect(source);
    }

    public AbstractSource createSource(MediaSink otherParty) {
        Output output = new Output(this.getName() + "[output]");
        output.setSyncSource(this.input);
        output.setEndpoint(this.getEndpoint());
        output.setConnection(this.getConnection());
        return output;
    }

    public void setConnection(Connection connection) {
        super.setConnection(connection);
        this.input.setConnection(connection);
        Collection<AbstractSource> list = this.getStreams();
        for (AbstractSource stream : list) {
            stream.setConnection(connection);
        }
    }

    public void setEndpoint(Endpoint endpoint) {
        super.setEndpoint(endpoint);
        this.input.setEndpoint(endpoint);
        Collection<AbstractSource> list = this.getStreams();
        for (AbstractSource stream : list) {
            stream.setEndpoint(endpoint);
        }
    }

    public Format[] getFormats() {
        return this.input.getOtherPartyFormats();
    }

    private void reassemblyFormats() {
        ArrayList<Format> list = new ArrayList<Format>();
        Collection<AbstractSource> streams = this.getStreams();
        for (AbstractSource stream : streams) {
            Format[] fmts;
            for (Format format : fmts = ((Output)stream).getOtherPartyFormats()) {
                if (list.contains(format)) continue;
                list.add(format);
            }
        }
        this.outputFormats = new Format[list.size()];
        list.toArray(this.outputFormats);
    }

    public void start() {
        this.input.start();
    }

    public void stop() {
        this.input.stop();
    }

    public void evolve(Buffer buffer, long timestamp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void destroySource(AbstractSource source) {
    }

    private class Output
    extends AbstractSource {
        public Output(String parent) {
            super(parent);
        }

        public void start() {
        }

        public void stop() {
        }

        public Format[] getOtherPartyFormats() {
            return this.otherParty != null ? this.otherParty.getFormats() : new Format[]{};
        }

        public Format[] getFormats() {
            return Demultiplexer.this.input.getOtherPartyFormats();
        }

        public void evolve(Buffer buffer, long timestamp) {
            buffer.copy(Demultiplexer.this.buff);
        }
    }

    private class Input
    extends AbstractSink
    implements SyncSource {
        public Input(String name) {
            super(name + "[input]");
        }

        protected Format[] getOtherPartyFormats() {
            return this.otherParty != null ? this.otherParty.getFormats() : new Format[]{};
        }

        public void onMediaTransfer(Buffer buffer) throws IOException {
            Demultiplexer.this.buff = buffer;
            Demultiplexer.this.timestamp = buffer.getTimeStamp();
            Collection<AbstractSource> streams = Demultiplexer.this.getStreams();
            for (AbstractSource stream : streams) {
                ((Output)stream).perform();
            }
            buffer.dispose();
        }

        public Format[] getFormats() {
            Demultiplexer.this.reassemblyFormats();
            return Demultiplexer.this.outputFormats;
        }

        public void sync(MediaSource mediaSource) {
        }

        public void unsync(MediaSource mediaSource) {
        }

        public long getTimestamp() {
            return Demultiplexer.this.timestamp;
        }

        public TimerTask sync(Task task) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

