/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.Outlet;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSinkSet;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.TimerTask;

public class Multiplexer
extends AbstractSinkSet
implements Outlet,
SyncSource {
    private Format[] inputFormats = null;
    private Output output;
    private Buffer buff;
    private long timestamp;

    public Multiplexer(String name) {
        super(name);
        this.output = new Output(name);
        this.output.setSyncSource(this);
    }

    public void connect(MediaSink sink) {
        this.output.connect(sink);
    }

    public void disconnect(MediaSink sink) {
        this.output.disconnect(sink);
    }

    public AbstractSink createSink(MediaSource otherParty) {
        Input input = new Input(this.getName() + "[input]");
        input.setEndpoint(this.getEndpoint());
        input.setConnection(this.getConnection());
        return input;
    }

    public void start() {
        this.output.start();
    }

    public void stop() {
        this.output.stop();
    }

    private String getIdentifier() {
        return this.getId();
    }

    public MediaSource getOutput() {
        return this.output;
    }

    public Format[] getFormats() {
        return this.output.getOtherPartyFormats();
    }

    public void setConnection(Connection connection) {
        super.setConnection(connection);
        this.output.setConnection(connection);
        Collection<AbstractSink> streams = this.getStreams();
        for (AbstractSink stream : streams) {
            stream.setConnection(connection);
        }
    }

    public void setEndpoint(Endpoint endpoint) {
        super.setEndpoint(endpoint);
        this.output.setEndpoint(endpoint);
        Collection<AbstractSink> list = this.getStreams();
        for (AbstractSink stream : list) {
            stream.setEndpoint(endpoint);
        }
    }

    private void reassemblyFormats() {
        ArrayList<Format> list = new ArrayList<Format>();
        Collection<AbstractSink> streams = this.getStreams();
        for (AbstractSink stream : streams) {
            Format[] fmts;
            for (Format format : fmts = ((Input)stream).getOtherPartyFormats()) {
                if (list.contains(format)) continue;
                list.add(format);
            }
        }
        this.inputFormats = new Format[list.size()];
        list.toArray(this.inputFormats);
    }

    public void onMediaTransfer(Buffer buffer) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void destroySink(AbstractSink sink) {
    }

    public void sync(MediaSource mediaSource) {
    }

    public void unsync(MediaSource mediaSource) {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TimerTask sync(Task task) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class Output
    extends AbstractSource {
        private volatile boolean stopped;

        public Output(String name) {
            super(name);
            this.stopped = true;
        }

        public void start() {
            this.stopped = false;
        }

        public void stop() {
            this.stopped = true;
        }

        public Format[] getFormats() {
            Multiplexer.this.reassemblyFormats();
            return Multiplexer.this.inputFormats;
        }

        public Format[] getOtherPartyFormats() {
            return this.otherParty != null ? this.otherParty.getFormats() : new Format[]{};
        }

        public void evolve(Buffer buffer, long timestamp) {
            if (!this.stopped) {
                buffer.copy(Multiplexer.this.buff);
            }
        }
    }

    class Input
    extends AbstractSink {
        public Input(String name) {
            super(name);
        }

        public String getId() {
            return Multiplexer.this.getIdentifier();
        }

        public void onMediaTransfer(Buffer buffer) throws IOException {
            Multiplexer.this.buff = buffer;
            Multiplexer.this.timestamp = buffer.getTimeStamp();
            Multiplexer.this.output.perform();
        }

        public Format[] getFormats() {
            return Multiplexer.this.output.getOtherPartyFormats();
        }

        protected Format[] getOtherPartyFormats() {
            return this.otherParty.getFormats();
        }
    }
}

