/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource;

import java.io.IOException;
import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.Inlet;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.Outlet;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.TimerTask;

public class Proxy
extends BaseComponent
implements Inlet,
Outlet {
    private Input input;
    private Output output;
    private Format[] formats = new Format[]{Format.ANY};
    private Buffer buff;
    private long timestamp;

    public Proxy(String name) {
        super(name);
        this.input = new Input(name);
        this.output = new Output(name);
        this.output.setSyncSource(this.input);
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public void setFormat(Format[] formats) {
        this.formats = formats;
    }

    public void start() {
        if (!this.input.isStarted()) {
            this.input.start();
        }
    }

    public void stop() {
        if (this.input.isStarted()) {
            this.input.stop();
        }
    }

    public MediaSink getInput() {
        return this.input;
    }

    public MediaSource getOutput() {
        return this.output;
    }

    public void connect(MediaSource source) {
        this.input.connect(source);
    }

    public void disconnect(MediaSource source) {
        this.input.disconnect(source);
    }

    public void connect(MediaSink sink) {
        this.output.connect(sink);
    }

    public void disconnect(MediaSink sink) {
        this.output.disconnect(sink);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Output
    extends AbstractSource {
        private volatile boolean started;

        public Output(String name) {
            super(name + "[output]");
            this.started = false;
        }

        @Override
        public boolean isStarted() {
            return this.started;
        }

        @Override
        public void start() {
            this.started = true;
            if (!Proxy.this.input.isStarted()) {
                Proxy.this.input.start();
            }
            super.start();
        }

        @Override
        public void stop() {
            this.started = false;
            if (Proxy.this.input.isStarted()) {
                Proxy.this.input.stop();
            }
            super.stop();
        }

        @Override
        public void setPreffered(Format format) {
            super.setPreffered(format);
            Proxy.this.input.assignPreffered(format);
        }

        public Format getOtherPartyPreffered(Collection<Format> set) {
            return ((AbstractSink)this.otherParty).getPreffered(set);
        }

        @Override
        public void evolve(Buffer buffer, long timestamp) {
            if (Proxy.this.buff != null) {
                buffer.copy(Proxy.this.buff);
            }
        }

        public Format[] getOtherPartyFormats() {
            return this.otherParty.getFormats();
        }

        public Format[] getFormats() {
            return Proxy.this.input.isConnected() ? Proxy.this.input.getOtherPartyFormats() : Proxy.this.formats;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Input
    extends AbstractSink
    implements SyncSource {
        private volatile boolean started;

        public Input(String name) {
            super(name + "[input]");
            this.started = false;
        }

        @Override
        public boolean isStarted() {
            return this.started;
        }

        @Override
        public void start() {
            this.started = true;
            if (!Proxy.this.output.isStarted()) {
                Proxy.this.output.start();
            }
            super.start();
        }

        @Override
        public void stop() {
            this.started = false;
            if (Proxy.this.output.isStarted()) {
                Proxy.this.output.stop();
            }
            super.stop();
        }

        @Override
        public void onMediaTransfer(Buffer buffer) throws IOException {
            Proxy.this.buff = buffer;
            Proxy.this.timestamp = buffer.getTimeStamp();
            Proxy.this.output.perform();
        }

        @Override
        public Format selectPreffered(Collection<Format> set) {
            return Proxy.this.output.isConnected() ? Proxy.this.output.getOtherPartyPreffered(set) : null;
        }

        public Format[] getFormats() {
            return Proxy.this.output.isConnected() ? Proxy.this.output.getOtherPartyFormats() : Proxy.this.formats;
        }

        public Format[] getOtherPartyFormats() {
            return this.otherParty.getFormats();
        }

        public void sync(MediaSource mediaSource) {
        }

        public void unsync(MediaSource mediaSource) {
        }

        public long getTimestamp() {
            return Proxy.this.timestamp;
        }

        public TimerTask sync(Task task) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

