/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.audio;

import java.util.ArrayList;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.dsp.audio.gsm.DecoderFactory;
import org.mobicents.media.server.impl.dsp.audio.speex.EncoderFactory;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.CodecFactory;

public class AudioNoiseGenerator
extends AbstractSource {
    private static final Format[] FORMATS = new Format[]{Codec.LINEAR_AUDIO, Codec.PCMA, Codec.PCMU, Codec.GSM, Codec.SPEEX, Codec.G729};
    private byte[] data = new byte[320];
    private Codec codec;
    private static final ArrayList<CodecFactory> codecFactories = new ArrayList();

    public AudioNoiseGenerator(String name, SyncSource syncSource) {
        super(name);
        this.setSyncSource(syncSource);
    }

    public void setPreffered(Format fmt) {
        this.codec = this.selectCodec(fmt);
        super.setPreffered(fmt);
    }

    private Codec selectCodec(Format f) {
        for (CodecFactory factory : codecFactories) {
            if (!factory.getSupportedOutputFormat().matches(f) || !factory.getSupportedInputFormat().matches((Format)Codec.LINEAR_AUDIO)) continue;
            return factory.getCodec();
        }
        return null;
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    public void evolve(Buffer buffer, long timestamp) {
        buffer.setData(this.data);
        buffer.setOffset(0);
        buffer.setLength(320);
        buffer.setFormat((Format)Codec.LINEAR_AUDIO);
        buffer.setTimeStamp(this.getSyncSource().getTimestamp());
        buffer.setFlags(4);
        if (this.codec != null) {
            this.codec.process(buffer);
        }
    }

    public void stop() {
    }

    static {
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.alaw.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.alaw.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.EncoderFactory());
        codecFactories.add(new DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.gsm.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.speex.DecoderFactory());
        codecFactories.add(new EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g729.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g729.EncoderFactory());
    }
}

