/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.audio;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Semaphore;
import org.mobicents.media.Buffer;

public class RecorderCache
extends InputStream {
    private int available = 0;
    private int offset;
    protected Semaphore semaphore = new Semaphore(0);
    protected volatile boolean blocked = false;
    private int bufferSize = 960000;
    private byte[] localBuffer = new byte[this.bufferSize];

    public int available() {
        return this.available;
    }

    public int read() throws IOException {
        if (this.available == 0) {
            return -1;
        }
        if (this.blocked) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }
        --this.available;
        int b = this.localBuffer[this.offset++] & 0xFF;
        return b;
    }

    private void resizeLocalBuffer() {
        byte[] temp = new byte[this.available];
        System.arraycopy(this.localBuffer, 0, temp, 0, this.available);
        this.localBuffer = new byte[2 * this.localBuffer.length];
        System.arraycopy(temp, 0, this.localBuffer, 0, this.available);
    }

    protected void push(Buffer buffer) {
        boolean enouphSpace;
        int remainder = this.localBuffer.length - this.available;
        boolean bl = enouphSpace = remainder > buffer.getLength();
        if (!enouphSpace) {
            this.resizeLocalBuffer();
        }
        byte[] data = buffer.getData();
        System.arraycopy(data, buffer.getOffset(), this.localBuffer, this.available, buffer.getLength());
        this.available += data.length;
    }

    protected void unblock() {
        this.semaphore.release();
    }
}

