/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.audio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.Utils;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.NotifyEventImpl;
import org.mobicents.media.server.impl.resource.audio.RecorderCache;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.resource.Recorder;
import org.xiph.speex.spi.SpeexEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderImpl
extends AbstractSink
implements Recorder {
    private static final Format[] FORMATS = new Format[]{AVProfile.PCMA, AVProfile.PCMU, AVProfile.SPEEX, Codec.LINEAR_AUDIO};
    private static final AudioFileFormat.Type GSM = new AudioFileFormat.Type("GSM0610", ".gsm");
    private static final AudioFileFormat.Type SPEEX = new AudioFileFormat.Type("SPEEX", ".spx");
    private static final AudioFormat.Encoding GSM_ENCODING = new AudioFormat.Encoding("GSM0610");
    private final NotifyEventImpl completedEvent;
    private String recordDir = null;
    private AudioFileFormat.Type fileType = AudioFileFormat.Type.WAVE;
    private RecorderCache recorderCache;
    private OutputStream outputStream;
    private AudioInputStream inputStream;
    private volatile boolean first = true;
    private AudioFormat format;
    private boolean isAcceptable = false;
    private Format fmt;

    public RecorderImpl(String name) {
        super(name);
        this.completedEvent = new NotifyEventImpl(this, 20000, "Completed");
    }

    public void setRecordDir(String recordDir) {
        if (recordDir == null) {
            throw new IllegalArgumentException("RecordDir cannot be null");
        }
        this.recordDir = recordDir;
    }

    public void setRecordFile(String passedURI) throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        try {
            URL targetURL = Utils.getAbsoluteURL((String)this.recordDir, (String)passedURI);
            if (targetURL.toURI().getScheme().equals("file")) {
                File f = new File(targetURL.getFile());
                f.getParentFile().mkdirs();
                this.outputStream = new FileOutputStream(f);
            } else {
                URLConnection urlConnection = targetURL.openConnection();
                urlConnection.connect();
                this.outputStream = urlConnection.getOutputStream();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void stop() {
        if (this.recorderCache != null && this.recorderCache.available() > 0) {
            this.inputStream = new AudioInputStream(this.recorderCache, this.format, this.recorderCache.available());
            this.recorderCache.unblock();
            new RecorderRunnable().run();
        }
        super.stop();
    }

    @Override
    public void start() {
        super.start();
        this.first = true;
    }

    private void release() {
        try {
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    public boolean isAcceptable(Format format) {
        if (this.fmt != null && this.fmt.matches(format)) {
            return this.isAcceptable;
        }
        for (int i = 0; i < FORMATS.length; ++i) {
            if (!FORMATS[i].matches(format)) continue;
            this.fmt = format;
            this.isAcceptable = true;
            return this.isAcceptable;
        }
        this.isAcceptable = false;
        return this.isAcceptable;
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        if (interfaceType.equals(Recorder.class)) {
            return (T)this;
        }
        return null;
    }

    private AudioFormat.Encoding getEncoding(String encodingName) {
        if (encodingName.equalsIgnoreCase("ALAW")) {
            return AudioFormat.Encoding.ALAW;
        }
        if (encodingName.equalsIgnoreCase("ULAW")) {
            return AudioFormat.Encoding.ULAW;
        }
        if (encodingName.equalsIgnoreCase("SPEEX")) {
            return SpeexEncoding.SPEEX;
        }
        if (encodingName.equalsIgnoreCase("GSM")) {
            return GSM_ENCODING;
        }
        return AudioFormat.Encoding.PCM_SIGNED;
    }

    private void openRecorderLine(org.mobicents.media.format.AudioFormat fmt) {
        float sampleRate = (float)fmt.getSampleRate();
        int sampleSizeInBits = fmt.getSampleSizeInBits();
        int channels = fmt.getChannels();
        boolean bigEndian = fmt.getEndian() == 1;
        AudioFormat.Encoding encoding = this.getEncoding(fmt.getEncoding());
        this.format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, 1, sampleRate, bigEndian);
        this.fileType = encoding == SpeexEncoding.SPEEX ? SPEEX : AudioFileFormat.Type.WAVE;
        this.recorderCache = new RecorderCache();
    }

    @Override
    public void onMediaTransfer(Buffer buffer) throws IOException {
        if (this.first) {
            this.first = false;
            this.openRecorderLine((org.mobicents.media.format.AudioFormat)buffer.getFormat());
        }
        this.recorderCache.push(buffer);
    }

    private class RecorderRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AudioSystem.write(RecorderImpl.this.inputStream, RecorderImpl.this.fileType, RecorderImpl.this.outputStream);
                RecorderImpl.this.sendEvent(RecorderImpl.this.completedEvent);
            }
            catch (Exception e) {
                RecorderImpl.this.failed(10003, e);
            }
            finally {
                RecorderImpl.this.release();
            }
        }
    }
}

