/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.audio.soundcard;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.spi.dsp.Codec;
import org.xiph.speex.spi.SpeexEncoding;

public class PlayerImpl
extends AbstractSink {
    private static final Format[] FORMATS = new Format[]{AVProfile.L16_MONO, AVProfile.L16_STEREO, Codec.LINEAR_AUDIO};
    private static final AudioFormat.Encoding GSM_ENCODING = new AudioFormat.Encoding("GSM0610");
    private volatile boolean first = true;
    boolean bigEndian = false;
    private SourceDataLine sourceDataLine = null;
    private boolean isAcceptable = false;
    private Format fmt;
    private AudioFormat audioFormat = null;

    public PlayerImpl(String name) {
        super(name);
    }

    private AudioFormat.Encoding getEncoding(String encodingName) {
        if (encodingName.equalsIgnoreCase("ALAW")) {
            return AudioFormat.Encoding.ALAW;
        }
        if (encodingName.equalsIgnoreCase("ULAW")) {
            return AudioFormat.Encoding.ULAW;
        }
        if (encodingName.equalsIgnoreCase("SPEEX")) {
            return SpeexEncoding.SPEEX;
        }
        if (encodingName.equalsIgnoreCase("GSM")) {
            return GSM_ENCODING;
        }
        return AudioFormat.Encoding.PCM_SIGNED;
    }

    public void onMediaTransfer(Buffer buffer) throws IOException {
        if (this.first) {
            this.first = false;
            org.mobicents.media.format.AudioFormat fmt = (org.mobicents.media.format.AudioFormat)buffer.getFormat();
            float sampleRate = (float)fmt.getSampleRate();
            int sampleSizeInBits = fmt.getSampleSizeInBits();
            int channels = fmt.getChannels();
            int frameSize = fmt.getFrameSizeInBits() / 8;
            float frameRate = fmt.getFrameRate();
            boolean bigEndian = fmt.getEndian() == 1;
            AudioFormat.Encoding encoding = this.getEncoding(fmt.getEncoding());
            frameSize = channels == -1 || sampleSizeInBits == -1 ? -1 : (sampleSizeInBits + 7) / 8 * channels;
            this.audioFormat = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, sampleRate, bigEndian);
            DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            try {
                this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
                this.sourceDataLine.open(this.audioFormat);
                this.sourceDataLine.start();
            }
            catch (LineUnavailableException e) {
                this.logger.error((Object)e);
                this.failed(10003, e);
                this.stop();
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)e);
                this.failed(10003, e);
                this.stop();
            }
        }
        byte[] data = buffer.getData();
        try {
            this.sourceDataLine.write(data, buffer.getOffset(), buffer.getLength());
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error((Object)e);
        }
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    public boolean isAcceptable(Format format) {
        if (this.fmt != null && this.fmt.matches(format)) {
            return this.isAcceptable;
        }
        for (int i = 0; i < FORMATS.length; ++i) {
            if (!FORMATS[i].matches(format)) continue;
            this.fmt = format;
            this.isAcceptable = true;
            return this.isAcceptable;
        }
        this.isAcceptable = false;
        return this.isAcceptable;
    }

    public void stop() {
        super.stop();
        this.first = false;
        if (this.sourceDataLine != null) {
            this.sourceDataLine.drain();
            this.sourceDataLine.close();
        }
    }

    public void start() {
        super.start();
        this.first = true;
    }
}

