/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.cnf;

import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.Outlet;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSinkSet;
import org.mobicents.media.server.impl.resource.cnf.MixerInputStream;
import org.mobicents.media.server.impl.resource.cnf.MixerOutput;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Timer;

public class AudioMixer
extends AbstractSinkSet
implements Outlet {
    protected static final AudioFormat LINEAR = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    protected static final Format[] formats = new Format[]{LINEAR};
    private int packetSize;
    private int packetPeriod = 20;
    private MixerOutput mixerOutput = new MixerOutput(this);
    private int channelCount;
    private byte[][] frames;

    public AudioMixer(String name, Timer timer) {
        super(name);
        this.mixerOutput.setSyncSource((SyncSource)timer);
        this.init();
    }

    private void init() {
        this.packetSize = 16 * this.packetPeriod;
    }

    public MediaSource getOutput() {
        return this.mixerOutput;
    }

    public void start() {
        this.mixerOutput.start();
    }

    public void stop() {
        this.mixerOutput.stop();
    }

    public void setEndpoint(Endpoint endpoint) {
        super.setEndpoint(endpoint);
        this.mixerOutput.setEndpoint(endpoint);
        Collection<AbstractSink> streams = this.getStreams();
        for (AbstractSink stream : streams) {
            stream.setEndpoint(endpoint);
        }
    }

    public void setConnection(Connection connection) {
        super.setConnection(connection);
        this.mixerOutput.setConnection(connection);
        Collection<AbstractSink> streams = this.getStreams();
        for (AbstractSink stream : streams) {
            stream.setConnection(connection);
        }
    }

    public short[] byteToShortArray(byte[] input) {
        short[] output = new short[input.length >> 1];
        for (int q = 0; q < input.length; q += 2) {
            short f;
            output[q >> 1] = f = (short)(input[q + 1] << 8 | input[q] & 0xFF);
        }
        return output;
    }

    public byte[] mix(byte[][] frames) {
        int numSamples = this.packetSize >> 1;
        byte[] data = new byte[this.packetSize];
        int k = 0;
        for (int j = 0; j < this.packetSize; j += 2) {
            int s = 0;
            for (int i = 0; i < this.channelCount; ++i) {
                s = (short)(s + (short)(frames[i][j + 1] << 8 | frames[i][j] & 0xFF));
            }
            data[k++] = (byte)s;
            data[k++] = (byte)(s >> 8);
        }
        return data;
    }

    public void evolve(Buffer buffer, long timestamp) {
        this.channelCount = this.getStreams().size();
        int i = 0;
        this.frames = new byte[this.channelCount][320];
        Collection<AbstractSink> streams = this.getStreams();
        for (AbstractSink stream : streams) {
            MixerInputStream input = (MixerInputStream)stream;
            this.frames[i++] = input.read(this.packetPeriod);
        }
        byte[] data = this.mix(this.frames);
        buffer.setData(data);
        buffer.setOffset(0);
        buffer.setLength(data.length);
        buffer.setTimeStamp(timestamp);
        buffer.setDuration(20L);
        buffer.setFormat((Format)LINEAR);
        buffer.setEOM(false);
        buffer.setDiscard(false);
    }

    public boolean isAcceptable(Format fmt) {
        return fmt.matches((Format)LINEAR);
    }

    public void onMediaTransfer(Buffer buffer) {
        throw new UnsupportedOperationException();
    }

    public Format[] getFormats() {
        return formats;
    }

    public void connect(MediaSink sink) {
        this.getOutput().connect(sink);
    }

    public void disconnect(MediaSink sink) {
        this.getOutput().disconnect(sink);
    }

    public AbstractSink createSink(MediaSource otherParty) {
        MixerInputStream input = new MixerInputStream(this);
        return input;
    }

    public void destroySink(AbstractSink sink) {
        ((MixerInputStream)sink).mixer = null;
    }
}

