/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.cnf;

import java.io.IOException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.resource.cnf.AudioMixer;

public class MixerInputStream
extends AbstractSink {
    protected AudioMixer mixer;
    private byte[] media = new byte[320];
    private byte[] localBuffer = new byte[320];
    private long duration;
    private int r;
    private int w;

    public MixerInputStream(AudioMixer mixer) {
        super("MixerInputStream");
        this.mixer = mixer;
    }

    public String getId() {
        return this.mixer.getId();
    }

    public void onMediaTransfer(Buffer buffer) throws IOException {
        byte[] data = buffer.getData();
        int remainder = this.localBuffer.length - this.w - buffer.getLength();
        if (remainder >= 0) {
            System.arraycopy(data, buffer.getOffset(), this.localBuffer, this.w, buffer.getLength());
            this.inc(this.w, buffer.getLength());
            this.duration += buffer.getDuration();
            return;
        }
        remainder = -remainder;
        System.arraycopy(data, buffer.getOffset(), this.localBuffer, this.w, buffer.getLength() - remainder);
        if (remainder > this.r) {
            remainder = this.r;
        }
        System.arraycopy(buffer.getData(), buffer.getOffset() + (buffer.getLength() - remainder), this.localBuffer, 0, remainder);
        this.w = remainder;
        this.duration += buffer.getDuration();
    }

    private void print(String s, byte[] data) {
        System.out.println(System.currentTimeMillis() + " " + s);
        for (int i = 0; i < data.length; ++i) {
            System.out.print(data[i] + " ");
        }
        System.out.println();
    }

    public byte[] read(int duration) {
        int len = 320;
        for (int i = 0; i < this.media.length; ++i) {
            this.media[i] = 0;
        }
        if (this.duration > 0L) {
            int remainder = this.localBuffer.length - this.r - len;
            if (remainder >= 0) {
                System.arraycopy(this.localBuffer, this.r, this.media, 0, len);
                this.inc(this.r, len);
            } else {
                System.arraycopy(this.localBuffer, this.r, this.media, 0, len - remainder);
                System.arraycopy(this.localBuffer, 0, this.media, len - remainder, remainder);
                this.r = remainder;
            }
            this.duration -= (long)duration;
        }
        return this.media;
    }

    private int inc(int index, int amount) {
        return (index += amount) < this.localBuffer.length ? index : this.localBuffer.length - index;
    }

    public Format[] getFormats() {
        return AudioMixer.formats;
    }

    public String toString() {
        return this.mixer.toString();
    }
}

