/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.cnf;

import java.io.IOException;
import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.Inlet;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.AbstractSourceSet;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.TimerTask;
import org.mobicents.media.server.spi.dsp.Codec;

public class Splitter
extends AbstractSourceSet
implements Inlet {
    private Input input = null;
    private Buffer buff;
    private long timestamp;
    private Format[] formats = new Format[]{Codec.LINEAR_AUDIO};

    public Splitter(String name) {
        super(name);
        this.input = new Input(name);
    }

    public AbstractSink getInput() {
        return this.input;
    }

    public void connect(MediaSource source) {
        this.input.connect(source);
    }

    public void disconnect(MediaSource source) {
        this.input.disconnect(source);
    }

    public AbstractSource createSource(MediaSink otherParty) {
        Output output = new Output(this.getName() + "[output]");
        output.setSyncSource(this.input);
        output.setEndpoint(this.getEndpoint());
        output.setConnection(this.getConnection());
        return output;
    }

    public void setConnection(Connection connection) {
        super.setConnection(connection);
        this.input.setConnection(connection);
        Collection<AbstractSource> list = this.getStreams();
        for (AbstractSource stream : list) {
            stream.setConnection(connection);
        }
    }

    public void setEndpoint(Endpoint endpoint) {
        super.setEndpoint(endpoint);
        this.input.setEndpoint(endpoint);
        Collection<AbstractSource> list = this.getStreams();
        for (AbstractSource stream : list) {
            stream.setEndpoint(endpoint);
        }
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public void start() {
        this.input.start();
    }

    public void stop() {
        this.input.stop();
    }

    public void evolve(Buffer buffer, long timestamp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void destroySource(AbstractSource source) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Output
    extends AbstractSource {
        public Output(String parent) {
            super(parent);
        }

        @Override
        public void connect(MediaSink sink) {
            super.connect(sink);
        }

        public Format getOtherPartyPreffered(Collection<Format> set) {
            return this.isConnected() ? ((AbstractSink)this.otherParty).getPreffered(set) : null;
        }

        public Format[] getFormats() {
            return Splitter.this.formats;
        }

        @Override
        public void evolve(Buffer buffer, long timestamp) {
            buffer.copy(Splitter.this.buff);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Input
    extends AbstractSink
    implements SyncSource {
        public Input(String name) {
            super(name + "[input]");
        }

        @Override
        protected Format selectPreffered(Collection<Format> set) {
            return Codec.LINEAR_AUDIO;
        }

        @Override
        public void onMediaTransfer(Buffer buffer) throws IOException {
            Splitter.this.buff = buffer;
            Splitter.this.timestamp = buffer.getTimeStamp();
            Collection<AbstractSource> streams = Splitter.this.getStreams();
            for (AbstractSource stream : streams) {
                if (!stream.isStarted()) continue;
                ((Output)stream).perform();
            }
            buffer.dispose();
        }

        public Format[] getFormats() {
            return Splitter.this.formats;
        }

        public void sync(MediaSource mediaSource) {
        }

        public void unsync(MediaSource mediaSource) {
        }

        public long getTimestamp() {
            return Splitter.this.timestamp;
        }

        public TimerTask sync(Task task) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

