/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.dtmf;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.resource.dtmf.DtmfEvent;
import org.mobicents.media.server.spi.resource.DtmfDetector;

public abstract class DtmfBuffer
extends AbstractSink
implements DtmfDetector,
Serializable {
    public static final int TIMEOUT = 5000;
    private static final String DETECTOR_MASK = "[0-9, A,B,C,D,*,#]";
    public int interdigitInterval = 500;
    private StringBuffer buffer = new StringBuffer();
    private Matcher matcher;
    private String mask;
    private Pattern maskPattern;
    private long lastActivity = System.currentTimeMillis();
    private String lastSymbol;
    private transient Logger logger = Logger.getLogger(DtmfBuffer.class);

    public DtmfBuffer(String name) {
        super(name);
        this.buffer = new StringBuffer();
        this.maskPattern = Pattern.compile(DETECTOR_MASK);
        this.setMask(DETECTOR_MASK);
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public void setInterdigitInterval(int silence) {
        this.interdigitInterval = silence;
    }

    public int getInterdigitInterval() {
        return this.interdigitInterval;
    }

    public void push(String symbol) {
        long now = System.currentTimeMillis();
        if (now - this.lastActivity > 5000L) {
            this.buffer = new StringBuffer();
        }
        if (!symbol.equals(this.lastSymbol) || now - this.lastActivity > (long)this.interdigitInterval) {
            this.buffer.append(symbol);
            this.lastActivity = now;
            this.lastSymbol = symbol;
            String digits = this.buffer.toString();
            this.matcher = this.maskPattern.matcher(digits);
            if (this.matcher.matches()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Send DTMF event: " + digits));
                }
                int eventId = 0;
                if (digits.equals("0")) {
                    eventId = 0;
                } else if (digits.equals("1")) {
                    eventId = 1;
                } else if (digits.equals("2")) {
                    eventId = 2;
                } else if (digits.equals("3")) {
                    eventId = 3;
                } else if (digits.equals("4")) {
                    eventId = 4;
                } else if (digits.equals("5")) {
                    eventId = 5;
                } else if (digits.equals("6")) {
                    eventId = 6;
                } else if (digits.equals("7")) {
                    eventId = 7;
                } else if (digits.equals("8")) {
                    eventId = 8;
                } else if (digits.equals("9")) {
                    eventId = 9;
                } else if (digits.equals("A")) {
                    eventId = 10;
                } else if (digits.equals("B")) {
                    eventId = 11;
                } else if (digits.equals("C")) {
                    eventId = 12;
                } else if (digits.equals("D")) {
                    eventId = 13;
                } else if (symbol.equals("*")) {
                    eventId = 15;
                } else if (symbol.equals("#")) {
                    eventId = 14;
                } else {
                    this.logger.error((Object)("DTMF event " + symbol + " not identified"));
                    return;
                }
                DtmfEvent dtmfEvent = new DtmfEvent((BaseComponent)this, eventId, 0);
                super.sendEvent(dtmfEvent);
                this.buffer = new StringBuffer();
            }
        }
    }
}

