/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.dtmf;

import java.util.ArrayList;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.dsp.audio.g711.alaw.DecoderFactory;
import org.mobicents.media.server.impl.dsp.audio.g729.EncoderFactory;
import org.mobicents.media.server.impl.resource.dtmf.DtmfEvent;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.CodecFactory;
import org.mobicents.media.server.spi.resource.DtmfGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorImpl
extends AbstractSource
implements DtmfGenerator {
    private static final AudioFormat LINEAR_AUDIO = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private static final Format[] FORMATS = new Format[]{Codec.LINEAR_AUDIO, Codec.PCMA, Codec.PCMU, Codec.GSM, Codec.SPEEX, Codec.G729};
    public static final String[][] events = new String[][]{{"1", "2", "3", "A"}, {"4", "5", "6", "B"}, {"7", "8", "9", "C"}, {"*", "0", "#", "D"}};
    private int[] lowFreq = new int[]{697, 770, 852, 941};
    private int[] highFreq = new int[]{1209, 1336, 1477, 1633};
    private String digit = null;
    private int duration = 50;
    private short A = (short)16383;
    private int volume = 0;
    private int f1;
    private int f2;
    private double dt;
    private int pSize;
    private double time = 0.0;
    private Codec codec;
    private static final ArrayList<CodecFactory> codecFactories = new ArrayList();

    public GeneratorImpl(String name, SyncSource syncSource) {
        super(name);
        this.setSyncSource(syncSource);
        this.dt = 1.0 / LINEAR_AUDIO.getSampleRate();
    }

    @Override
    public void start() {
        if (this.digit == null) {
            return;
        }
        super.start();
    }

    @Override
    public void setPreffered(Format fmt) {
        this.codec = this.selectCodec(fmt);
        super.setPreffered(fmt);
    }

    private Codec selectCodec(Format f) {
        for (CodecFactory factory : codecFactories) {
            if (!factory.getSupportedOutputFormat().matches(f) || !factory.getSupportedInputFormat().matches((Format)Codec.LINEAR_AUDIO)) continue;
            return factory.getCodec();
        }
        return null;
    }

    public void setDigit(String digit) {
        this.digit = digit;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!events[i][j].equalsIgnoreCase(digit)) continue;
                this.f1 = this.lowFreq[i];
                this.f2 = this.highFreq[j];
            }
        }
    }

    public String getDigit() {
        return this.digit;
    }

    public void setToneDuration(int duration) {
        if (duration < 40) {
            throw new IllegalArgumentException("Duration cannot be less than 40ms");
        }
        this.duration = duration;
    }

    public int getToneDuration() {
        return this.duration;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        if (volume > 0) {
            throw new IllegalArgumentException("Volume has to be negative value expressed in dBm0");
        }
        this.volume = volume;
        this.A = (short)(Math.pow(Math.pow(10.0, volume), 0.1) * 16383.0);
    }

    private short getValue(double t) {
        return (short)((double)this.A * (Math.sin(Math.PI * 2 * (double)this.f1 * t) + Math.sin(Math.PI * 2 * (double)this.f2 * t)));
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    @Override
    public void evolve(Buffer buffer, long timestamp) {
        int k = 0;
        int frameSize = (int)(0.02 / this.dt);
        byte[] data = new byte[2 * frameSize];
        for (int i = 0; i < frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        buffer.setHeader((Object)new DtmfEvent((BaseComponent)this, DtmfEvent.getId(this.digit), this.volume));
        buffer.setData(data);
        buffer.setOffset(0);
        buffer.setLength(2 * frameSize);
        buffer.setFormat((Format)LINEAR_AUDIO);
        buffer.setTimeStamp(this.getMediaTime());
        buffer.setDuration(20L);
        if (this.time == 0.0) {
            buffer.setFlags(16);
        }
        this.time += 0.02;
        buffer.setEOM(this.time > (double)this.duration / 1000.0);
        if (this.codec != null) {
            this.codec.process(buffer);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        if (interfaceType.equals(DtmfGenerator.class)) {
            return (T)this;
        }
        return null;
    }

    static {
        codecFactories.add(new DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.alaw.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.gsm.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.gsm.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.speex.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.speex.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g729.DecoderFactory());
        codecFactories.add(new EncoderFactory());
    }
}

