/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.echo;

import java.util.ArrayList;
import java.util.Collection;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.resource.Proxy;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Echo
extends BaseComponent
implements ResourceGroup {
    private Proxy audioProxy;
    private Proxy videoProxy;
    private static ArrayList<MediaType> mediaTypes = new ArrayList();

    public Echo(String name) {
        super(name);
        this.audioProxy = new Proxy(name + ".proxy.audio");
        this.videoProxy = new Proxy(name + ".proxy.video");
    }

    public Collection<MediaType> getMediaTypes() {
        return mediaTypes;
    }

    public MediaSink getSink(MediaType media) {
        return media == MediaType.AUDIO ? this.audioProxy.getInput() : this.videoProxy.getInput();
    }

    public MediaSource getSource(MediaType media) {
        return media == MediaType.AUDIO ? this.audioProxy.getOutput() : this.videoProxy.getOutput();
    }

    public void start() {
        this.audioProxy.start();
        this.videoProxy.start();
    }

    public void stop() {
        this.audioProxy.stop();
        this.videoProxy.stop();
    }

    static {
        mediaTypes.add(MediaType.AUDIO);
        mediaTypes.add(MediaType.VIDEO);
    }
}

