/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.fft;

import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.resource.fft.Complex;

public class FFT {
    private static Logger logger = Logger.getLogger(FFT.class);

    public Complex[] fft(Complex[] x) {
        int k;
        int N = x.length;
        Complex[] y = new Complex[N];
        if (N == 1) {
            y[0] = x[0];
            return y;
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        Complex[] odd = new Complex[N / 2];
        for (k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        for (k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] q = this.fft(even);
        Complex[] r = this.fft(odd);
        for (int k2 = 0; k2 < N / 2; ++k2) {
            double kth = (double)(-2 * k2) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k2] = q[k2].plus(wk.times(r[k2]));
            y[k2 + N / 2] = q[k2].minus(wk.times(r[k2]));
        }
        return y;
    }

    public static void show(Complex[] x, String title) {
        logger.debug((Object)title);
        logger.debug((Object)"-------------------");
        for (int i = 0; i < x.length; ++i) {
            logger.debug((Object)x[i]);
        }
        logger.debug((Object)"");
    }
}

