/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.Utils;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.dsp.audio.g711.alaw.DecoderFactory;
import org.mobicents.media.server.impl.dsp.audio.g729.EncoderFactory;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.gsm.GsmTrackImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.mpeg.AMRTrackImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.tts.TtsTrackImpl;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.wav.WavTrackImpl;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Timer;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.CodecFactory;
import org.mobicents.media.server.spi.resource.Player;
import org.mobicents.media.server.spi.resource.TTSEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioPlayerImpl
extends AbstractSource
implements Player,
TTSEngine {
    private static final AudioFormat LINEAR_AUDIO = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private static final ArrayList<String> mediaTypes = new ArrayList();
    private static final Format[] FORMATS;
    private Track track;
    private Codec codec;
    private String audioMediaDirectory;
    private static final CodecFactory[] codecFactories;
    private String voiceName = "kevin";
    private int volume;

    private Codec selectCodec(Format f) {
        for (CodecFactory factory : codecFactories) {
            if (!factory.getSupportedInputFormat().matches(f) || !factory.getSupportedOutputFormat().matches(this.format)) continue;
            return factory.getCodec();
        }
        return null;
    }

    public AudioPlayerImpl(String name, Timer timer, String audioMediaDirectory) {
        super(name);
        this.setSyncSource((SyncSource)timer);
        this.audioMediaDirectory = audioMediaDirectory;
    }

    @Override
    public long getDuration() {
        return this.track.getDuration();
    }

    @Override
    public void setMediaTime(long timestamp) {
        this.track.setMediaTime(timestamp);
    }

    @Override
    public long getMediaTime() {
        return this.track.getMediaTime();
    }

    public void setURL(String passedURI) throws IOException, ResourceUnavailableException {
        block10: {
            if (!this.isConnected()) {
                throw new IllegalStateException("Component should be connected");
            }
            int pos = passedURI.lastIndexOf(46);
            if (pos == -1) {
                throw new IOException("Unknow file type: " + passedURI);
            }
            String ext = passedURI.substring(pos + 1).toLowerCase();
            try {
                URL targetURL = Utils.getAbsoluteURL((String)this.audioMediaDirectory, (String)passedURI);
                if (ext.matches("wav")) {
                    this.track = new WavTrackImpl(targetURL);
                    break block10;
                }
                if (ext.matches("gsm")) {
                    this.track = new GsmTrackImpl(targetURL);
                    break block10;
                }
                if (ext.matches("txt")) {
                    this.track = new TtsTrackImpl(targetURL, this.voiceName);
                    break block10;
                }
                if (ext.matches("mov") || ext.matches("mp4") || ext.matches("3gp")) {
                    this.track = new AMRTrackImpl(targetURL);
                    break block10;
                }
                throw new ResourceUnavailableException("Unknown extension: " + passedURI);
            }
            catch (Exception e) {
                throw new ResourceUnavailableException((Throwable)e);
            }
        }
        Format fileFormat = this.track.getFormat();
        this.codec = null;
        if (!fileFormat.matches(this.getFormat())) {
            this.codec = this.selectCodec(fileFormat);
            if (this.codec == null) {
                throw new ResourceUnavailableException("Format is not supported: " + fileFormat);
            }
        }
    }

    @Override
    public void start() {
        if (this.track == null) {
            throw new IllegalStateException("The media source is not specified");
        }
        super.start();
    }

    @Override
    public void stop() {
        if (this.track != null) {
            this.track.close();
            this.track = null;
        }
        super.stop();
    }

    @Override
    public void evolve(Buffer buffer, long timestamp) {
        try {
            this.track.process(buffer);
            buffer.setTimeStamp(timestamp);
            if (this.codec != null && !buffer.isEOM()) {
                this.codec.process(buffer);
            }
            if (buffer.isEOM()) {
                this.track.close();
            }
        }
        catch (IOException e) {
            this.track.close();
            this.failed(10002, e);
            buffer.setDuration(0L);
        }
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    public void setVoiceName(String voiceName) {
        this.voiceName = voiceName;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setText(String text) {
        this.track = new TtsTrackImpl(text, this.voiceName);
        Format fileFormat = this.track.getFormat();
        this.codec = null;
        if (!fileFormat.matches(this.getFormat())) {
            this.codec = this.selectCodec(fileFormat);
            if (this.codec == null) {
                // empty if block
            }
        }
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        if (interfaceType.equals(Player.class)) {
            return (T)this;
        }
        if (interfaceType.equals(TTSEngine.class)) {
            return (T)this;
        }
        return null;
    }

    static {
        mediaTypes.add("audio");
        FORMATS = new Format[]{AVProfile.L16_MONO, AVProfile.L16_STEREO, AVProfile.PCMA, AVProfile.PCMU, AVProfile.SPEEX, AVProfile.GSM, LINEAR_AUDIO};
        codecFactories = new CodecFactory[]{new DecoderFactory(), new org.mobicents.media.server.impl.dsp.audio.g711.alaw.EncoderFactory(), new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.DecoderFactory(), new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.EncoderFactory(), new org.mobicents.media.server.impl.dsp.audio.gsm.DecoderFactory(), new org.mobicents.media.server.impl.dsp.audio.gsm.EncoderFactory(), new org.mobicents.media.server.impl.dsp.audio.speex.DecoderFactory(), new org.mobicents.media.server.impl.dsp.audio.speex.EncoderFactory(), new org.mobicents.media.server.impl.dsp.audio.g729.DecoderFactory(), new EncoderFactory()};
    }
}

