/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio.mpeg;

import java.io.IOException;
import java.net.URL;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.AudioTrack;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.MpegPresentation;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPLocalPacket;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPSample;

public class AMRTrackImpl
implements Track {
    private MpegPresentation presentation;
    private AudioTrack track;
    private RTPLocalPacket[] packets;
    private boolean eom = false;
    private int idx;
    private boolean isEmpty = true;
    private long duration;
    private long ssrc;

    public AMRTrackImpl(URL url) throws IOException {
        this.presentation = new MpegPresentation(url);
        this.track = this.presentation.getAudioTrack();
    }

    public Format getFormat() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void process(Buffer buffer) throws IOException {
        if (this.isEmpty) {
            try {
                RTPSample rtpSample = this.track.process();
                if (rtpSample == null) {
                    buffer.setEOM(this.eom);
                    return;
                }
                this.packets = rtpSample.getRtpLocalPackets();
                this.duration = rtpSample.getSamplePeriod();
                if (this.packets.length == 0) {
                    buffer.setLength(0);
                    buffer.setDuration(this.duration);
                    return;
                }
                this.idx = 0;
                this.isEmpty = false;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        byte[] data = this.packets[this.idx++].toByteArray(this.ssrc);
        this.isEmpty = this.idx == this.packets.length;
        buffer.setData(data);
        buffer.setLength(data.length);
        buffer.setTimeStamp(0L);
        buffer.setOffset(0);
        buffer.setSequenceNumber(0L);
        buffer.setEOM(this.eom);
        buffer.setFlags(buffer.getFlags() | 0x800);
        buffer.setDuration(this.isEmpty ? this.duration : -1L);
    }

    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getMediaTime() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMediaTime(long timestamp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getDuration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

