/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio.tts;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.audio.AudioPlayer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.tts.VoiceManager;

public class TtsTrackImpl
implements Track {
    private transient AudioInputStream stream = null;
    private org.mobicents.media.format.AudioFormat format = new org.mobicents.media.format.AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private int period = 20;
    private int frameSize;
    private boolean eom;
    private boolean isReady = false;
    private Vector<InputStream> outputList;
    private Voice voice;
    private long duration;
    private long timestamp;

    public TtsTrackImpl(URL url, String voiceName) throws IOException {
        URLConnection connection = url.openConnection();
        this.frameSize = (int)((double)(this.period * this.format.getChannels() * this.format.getSampleSizeInBits()) * this.format.getSampleRate() / 8000.0);
        VoiceManager voiceManager = VoiceManager.getInstance();
        this.voice = voiceManager.getVoice(voiceName);
        this.voice.allocate();
        TTSAudioBuffer audioBuffer = new TTSAudioBuffer();
        this.voice.setAudioPlayer((AudioPlayer)audioBuffer);
        this.voice.speak(connection.getInputStream());
        audioBuffer.flip();
    }

    public TtsTrackImpl(String text, String voiceName) {
        VoiceManager voiceManager = VoiceManager.getInstance();
        this.voice = voiceManager.getVoice(voiceName);
        this.voice.allocate();
        TTSAudioBuffer audioBuffer = new TTSAudioBuffer();
        this.voice.setAudioPlayer((AudioPlayer)audioBuffer);
        this.voice.speak(text);
        audioBuffer.flip();
        this.frameSize = (int)((double)(this.period * this.format.getChannels() * this.format.getSampleSizeInBits()) * this.format.getSampleRate() / 8000.0);
    }

    public void setPeriod(int period) {
        this.period = period;
        this.frameSize = (int)((double)(period * this.format.getChannels() * this.format.getSampleSizeInBits()) * this.format.getSampleRate() / 8000.0);
    }

    public int getPeriod() {
        return this.period;
    }

    public long getMediaTime() {
        return this.timestamp;
    }

    public void setMediaTime(long timestamp) {
        this.timestamp = timestamp;
        try {
            this.stream.reset();
            long offset = (long)this.frameSize * (timestamp / (long)this.period);
            this.stream.skip(offset);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getDuration() {
        return this.duration;
    }

    private int readPacket(byte[] packet, int offset, int psize) throws IOException {
        int length;
        try {
            int len;
            for (length = 0; length < psize; length += len) {
                len = this.stream.read(packet, offset + length, psize - length);
                if (len != -1) continue;
                return length;
            }
            return length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return length;
        }
    }

    private void padding(byte[] data, int count) {
        int offset = data.length - count;
        for (int i = 0; i < count; ++i) {
            data[i + offset] = 0;
        }
    }

    private void switchEndian(byte[] b, int off, int readCount) {
        for (int i = off; i < off + readCount; i += 2) {
            byte temp = b[i];
            b[i] = b[i + 1];
            b[i + 1] = temp;
        }
    }

    public void process(Buffer buffer) throws IOException {
        if (!this.isReady) {
            buffer.setDiscard(true);
            return;
        }
        byte[] data = buffer.getData();
        if (data == null) {
            data = new byte[this.frameSize];
        }
        buffer.setData(data);
        int len = this.readPacket(data, 0, this.frameSize);
        if (len == 0) {
            this.eom = true;
        }
        this.switchEndian(data, 0, data.length);
        if (len < this.frameSize) {
            this.padding(data, this.frameSize - len);
            this.eom = true;
        }
        buffer.setOffset(0);
        buffer.setLength(this.frameSize);
        buffer.setEOM(this.eom);
        buffer.setDuration(20L);
    }

    public void close() {
        try {
            this.voice.deallocate();
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Format getFormat() {
        return this.format;
    }

    private class TTSAudioBuffer
    implements AudioPlayer {
        private AudioFormat fmt;
        private float volume;
        private byte[] localBuff;
        private int curIndex = 0;
        private int totalBytes = 0;

        public TTSAudioBuffer() {
            TtsTrackImpl.this.outputList = new Vector();
        }

        public void setAudioFormat(AudioFormat fmt) {
            this.fmt = fmt;
        }

        public AudioFormat getAudioFormat() {
            return this.fmt;
        }

        public void pause() {
        }

        public void resume() {
        }

        public void reset() {
            this.curIndex = 0;
            this.localBuff = null;
            TtsTrackImpl.this.isReady = false;
        }

        public boolean drain() {
            return true;
        }

        public void begin(int size) {
            this.localBuff = new byte[size];
            this.curIndex = 0;
        }

        public boolean end() {
            TtsTrackImpl.this.outputList.add(new ByteArrayInputStream(this.localBuff));
            this.totalBytes += this.localBuff.length;
            TtsTrackImpl.this.isReady = true;
            return true;
        }

        public void cancel() {
        }

        public void close() {
        }

        public void flip() {
            SequenceInputStream is = new SequenceInputStream(TtsTrackImpl.this.outputList.elements());
            TtsTrackImpl.this.stream = new AudioInputStream(is, this.fmt, this.totalBytes / this.fmt.getFrameSize());
            TtsTrackImpl.this.duration = this.totalBytes / 320 * 20;
        }

        public float getVolume() {
            return this.volume;
        }

        public void setVolume(float volume) {
            this.volume = volume;
        }

        public long getTime() {
            return 0L;
        }

        public void resetTime() {
        }

        public void startFirstSampleTimer() {
        }

        public boolean write(byte[] buff) {
            return this.write(buff, 0, buff.length);
        }

        public boolean write(byte[] buff, int off, int len) {
            System.arraycopy(buff, off, this.localBuff, this.curIndex, len);
            this.curIndex += len;
            return true;
        }

        public void showMetrics() {
        }
    }
}

