/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.Box;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPConstructor;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPImmediateConstructor;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPLocalPacket;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPSample;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RTPSampleConstructor;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.RtpHintSampleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleTableBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TimeScaleEntry;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TimeToSampleBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TrackBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TrackHintInformation;

public abstract class RTPTrack {
    private final Logger logger = Logger.getLogger(this.getClass());
    private List<RTPLocalPacket> rtPktList = new ArrayList<RTPLocalPacket>();
    private TrackBox hintTrackBox = null;
    private TrackBox trackBox = null;
    private RandomAccessFile hintTrackRAF = null;
    private RandomAccessFile trackRAF = null;
    private long[] hintSamplesOffSet = null;
    private long[] samplesOffSet = null;
    private long[] sampleDelta = null;
    private int period = 0;
    private int[] timeDelta = null;
    private volatile int hintSamplesSent = 0;
    private volatile int audioSamplesSent = 0;
    private volatile long rtpTimeStamp = Math.abs(new Random().nextInt());
    private String sdpText;
    private long trackId = -1L;
    long hintSampleCount = 0L;
    double npt;
    boolean first = true;

    public RTPTrack(TrackBox audioTrackBox, TrackBox audioHintTrackBox, File file) throws FileNotFoundException {
        int j;
        long sampleCount = 0L;
        SampleTableBox hintSampleTableBox = null;
        SampleTableBox sampleTableBox = null;
        long[] hintChunkOffset = null;
        long[] hintSamplesPerChunk = null;
        long[] hintEntrySize = null;
        long hintSampleSize = 0L;
        int timeScale = 0;
        this.trackBox = audioTrackBox;
        this.hintTrackBox = audioHintTrackBox;
        this.hintTrackRAF = new RandomAccessFile(file, "r");
        this.trackRAF = new RandomAccessFile(file, "r");
        this.npt = this.hintTrackBox.getMediaBox().getMediaHeaderBox().getDuration() / this.hintTrackBox.getMediaBox().getMediaHeaderBox().getTimescale();
        this.trackId = this.hintTrackBox.getTrackHeaderBox().getTrackID();
        for (Box b : this.hintTrackBox.getUserDataBox().getUserDefinedBoxes()) {
            if (!b.getType().equals(TrackHintInformation.TYPE_S)) continue;
            this.sdpText = ((TrackHintInformation)b).getRtpTrackSdpHintInformation().getSdpText();
        }
        hintSampleTableBox = this.hintTrackBox.getMediaBox().getMediaInformationBox().getSampleTableBox();
        sampleTableBox = this.trackBox.getMediaBox().getMediaInformationBox().getSampleTableBox();
        hintChunkOffset = hintSampleTableBox.getChunkOffsetBox().getChunkOffset();
        long[] audioChunkOffset = sampleTableBox.getChunkOffsetBox().getChunkOffset();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Hint ChunkOffset length = " + hintChunkOffset.length));
            this.logger.debug((Object)("ChunkOffset length = " + audioChunkOffset.length));
        }
        for (SampleEntry sampleEntry : hintSampleTableBox.getSampleDescription().getSampleEntries()) {
            if (!sampleEntry.getType().equals(RtpHintSampleEntry.TYPE_S)) continue;
            for (Box box : ((RtpHintSampleEntry)sampleEntry).getAdditionaldata()) {
                if (!box.getType().equals(TimeScaleEntry.TYPE_S)) continue;
                timeScale = ((TimeScaleEntry)box).getTimeScale();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("timeScale = " + timeScale));
            }
        }
        this.hintSampleCount = hintSampleTableBox.getSampleSizeBox().getSampleCount();
        sampleCount = sampleTableBox.getSampleSizeBox().getSampleCount();
        TimeToSampleBox timeToSampleBox = hintSampleTableBox.getTimeToSampleBox();
        if (timeToSampleBox.getEntryCount() == 1L) {
            this.period = (int)((float)timeToSampleBox.getSampleDelta()[0] / (float)timeScale * 1000.0f);
        } else {
            int heartBeatArrCount = 0;
            this.timeDelta = new int[(int)this.hintSampleCount];
            long[] sampleCountArr = timeToSampleBox.getSampleCount();
            long[] sampleDelta = timeToSampleBox.getSampleDelta();
            for (int i = 0; i < sampleCountArr.length; ++i) {
                long temp = sampleCountArr[i];
                this.timeDelta[heartBeatArrCount++] = (int)((float)sampleDelta[i] / (float)timeScale * 1000.0f);
                j = 1;
                while ((long)j < temp) {
                    this.timeDelta[heartBeatArrCount++] = (int)sampleDelta[i];
                    ++j;
                }
            }
        }
        this.hintSamplesOffSet = new long[(int)this.hintSampleCount];
        this.samplesOffSet = new long[(int)sampleCount];
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Heart Beat = " + this.period));
            if (this.period == 0) {
                this.logger.debug((Object)("heartBeat zero so use heartBeatArr. Length = " + this.timeDelta.length));
            }
        }
        hintSamplesPerChunk = new long[hintChunkOffset.length];
        long[] audioSamplesPerChunk = new long[audioChunkOffset.length];
        int samplesPerChunkCount = 0;
        long[] hintFirstChunk = hintSampleTableBox.getSampleToChunkBox().getFirstChunk();
        long[] hintSamplesPerChunkTemp = hintSampleTableBox.getSampleToChunkBox().getSamplesPerChunk();
        for (int i = 0; i < hintFirstChunk.length - 1; ++i) {
            long temp = hintFirstChunk[i + 1] - hintFirstChunk[i];
            long samplesAtChunk = hintSamplesPerChunkTemp[i];
            int j2 = 0;
            while ((long)j2 < temp) {
                hintSamplesPerChunk[samplesPerChunkCount++] = samplesAtChunk;
                ++j2;
            }
        }
        long samplesAtChunk = hintSamplesPerChunkTemp[hintFirstChunk.length - 1];
        for (j = samplesPerChunkCount; j < hintSamplesPerChunk.length; ++j) {
            hintSamplesPerChunk[samplesPerChunkCount++] = samplesAtChunk;
        }
        samplesPerChunkCount = 0;
        long[] audioFirstChunk = sampleTableBox.getSampleToChunkBox().getFirstChunk();
        long[] audioSamplesPerChunkTemp = sampleTableBox.getSampleToChunkBox().getSamplesPerChunk();
        for (int i = 0; i < audioFirstChunk.length - 1; ++i) {
            long temp = audioFirstChunk[i + 1] - audioFirstChunk[i];
            samplesAtChunk = audioSamplesPerChunkTemp[i];
            int j3 = 0;
            while ((long)j3 < temp) {
                audioSamplesPerChunk[samplesPerChunkCount++] = samplesAtChunk;
                ++j3;
            }
        }
        samplesAtChunk = audioSamplesPerChunkTemp[audioFirstChunk.length - 1];
        for (int j4 = samplesPerChunkCount; j4 < audioSamplesPerChunk.length; ++j4) {
            audioSamplesPerChunk[samplesPerChunkCount++] = samplesAtChunk;
        }
        if (this.logger.isDebugEnabled()) {
            int i;
            int tempCnt = 0;
            for (i = 0; i < hintSamplesPerChunk.length; ++i) {
                tempCnt = (int)((long)tempCnt + hintSamplesPerChunk[i]);
            }
            this.logger.debug((Object)("Total sample count for Hint Track that should match with SampleSizeBox sampleCount(" + this.hintSampleCount + ") = " + tempCnt));
            tempCnt = 0;
            for (i = 0; i < audioSamplesPerChunk.length; ++i) {
                tempCnt = (int)((long)tempCnt + audioSamplesPerChunk[i]);
            }
            this.logger.debug((Object)("Total sample count for Track that should match with SampleSizeBox sampleCount(" + sampleTableBox.getSampleSizeBox().getSampleCount() + ") = " + tempCnt));
        }
        hintSampleSize = hintSampleTableBox.getSampleSizeBox().getSampleSize();
        hintEntrySize = hintSampleTableBox.getSampleSizeBox().getEntrySize();
        int samplesOffSetCount = 0;
        for (int i = 0; i < hintChunkOffset.length; ++i) {
            long chunkOffForChunk = hintChunkOffset[i];
            long samplesInThisChunk = hintSamplesPerChunk[i];
            this.hintSamplesOffSet[samplesOffSetCount++] = chunkOffForChunk;
            int j5 = 1;
            while ((long)j5 < samplesInThisChunk) {
                this.hintSamplesOffSet[samplesOffSetCount++] = hintSampleSize == 0L ? this.hintSamplesOffSet[samplesOffSetCount - 2] + hintEntrySize[samplesOffSetCount - 2] : chunkOffForChunk + hintSampleSize * (long)j5;
                ++j5;
            }
        }
        long audioSampleSize = sampleTableBox.getSampleSizeBox().getSampleSize();
        long[] audioEntrySize = sampleTableBox.getSampleSizeBox().getEntrySize();
        samplesOffSetCount = 0;
        for (int i = 0; i < audioChunkOffset.length; ++i) {
            long chunkOffForChunk = audioChunkOffset[i];
            long samplesInThisChunk = audioSamplesPerChunk[i];
            this.samplesOffSet[samplesOffSetCount++] = chunkOffForChunk;
            int j6 = 1;
            while ((long)j6 < samplesInThisChunk) {
                this.samplesOffSet[samplesOffSetCount++] = audioSampleSize == 0L ? this.samplesOffSet[samplesOffSetCount - 2] + audioEntrySize[samplesOffSetCount - 2] : chunkOffForChunk + audioSampleSize * (long)j6;
                ++j6;
            }
        }
        this.sampleDelta = new long[(int)this.hintSampleCount];
        long[] hintSampleCountArr = hintSampleTableBox.getTimeToSampleBox().getSampleCount();
        long[] hintSampleDeltaArr = hintSampleTableBox.getTimeToSampleBox().getSampleDelta();
        samplesOffSetCount = 0;
        for (int i = 0; i < hintSampleCountArr.length; ++i) {
            long smplCnt = hintSampleCountArr[i];
            long smplDelts = hintSampleDeltaArr[i];
            for (int j7 = 0; j7 < (int)smplCnt; ++j7) {
                this.sampleDelta[samplesOffSetCount++] = smplDelts;
            }
        }
    }

    public void setRtpTime(long rtpTime) {
        this.rtpTimeStamp = rtpTime;
    }

    public RTPSample process() throws IOException {
        RTPSample rtpSample = null;
        if (this.hintSampleCount == (long)this.hintSamplesSent) {
            return null;
        }
        rtpSample = new RTPSample();
        RTPLocalPacket rtpPacket = null;
        long hintSampleOffset = this.hintSamplesOffSet[this.hintSamplesSent];
        long audioSampleOffSet = this.samplesOffSet[this.audioSamplesSent];
        this.hintTrackRAF.seek(hintSampleOffset);
        int packetCount = this.hintTrackRAF.read() << 8 | this.hintTrackRAF.read();
        rtpSample.setPacketCount(packetCount);
        if (packetCount > 0) {
            ++this.audioSamplesSent;
        }
        this.hintTrackRAF.skipBytes(2);
        if (this.first) {
            this.first = false;
        } else {
            this.rtpTimeStamp += this.sampleDelta[this.hintSamplesSent];
        }
        for (int i = 0; i < packetCount; ++i) {
            rtpPacket = new RTPLocalPacket();
            rtpPacket.load(this.hintTrackRAF);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (RTPConstructor rtpCons : rtpPacket.RTPConstructorList()) {
                switch (rtpCons.getConstructorType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        byte[] data = ((RTPImmediateConstructor)rtpCons).getData();
                        bos.write(data, 0, data.length);
                        break;
                    }
                    case 2: {
                        RTPSampleConstructor rtpSampCons = (RTPSampleConstructor)rtpCons;
                        byte[] rtpPaylod = null;
                        if (rtpSampCons.getTrackRefIndex() == -1) {
                            this.hintTrackRAF.seek(hintSampleOffset + rtpSampCons.getSampleOffSet());
                            rtpPaylod = new byte[rtpSampCons.getLength()];
                            this.hintTrackRAF.read(rtpPaylod, 0, rtpSampCons.getLength());
                        } else {
                            this.trackRAF.seek(audioSampleOffSet + rtpSampCons.getSampleOffSet());
                            rtpPaylod = new byte[rtpSampCons.getLength()];
                            int read = this.trackRAF.read(rtpPaylod, 0, rtpSampCons.getLength());
                        }
                        bos.write(rtpPaylod, 0, rtpPaylod.length);
                        break;
                    }
                }
            }
            rtpPacket.setPayload(bos.toByteArray());
            rtpPacket.setRtpTimestamp(this.rtpTimeStamp);
            rtpSample.addRtpLocalPackets(rtpPacket);
        }
        if ((double)this.period == 0.0) {
            rtpSample.setSamplePeriod(this.timeDelta[this.hintSamplesSent]);
        } else {
            rtpSample.setSamplePeriod(this.period);
        }
        ++this.hintSamplesSent;
        return rtpSample;
    }

    public void close() {
        try {
            if (this.hintTrackRAF != null) {
                this.hintTrackRAF.close();
            }
            if (this.trackRAF != null) {
                this.trackRAF.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hintTrackRAF = null;
        this.trackRAF = null;
        this.hintTrackBox = null;
        this.trackBox = null;
        this.hintSamplesOffSet = null;
        this.samplesOffSet = null;
        this.timeDelta = null;
    }

    public String getSdpText() {
        return this.sdpText;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public float getPacketPeriod() {
        return this.period;
    }

    public float getHeartBeat() {
        return this.period;
    }

    public double getNPT() {
        return this.npt;
    }
}

