/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.FullBox;

public class TrackHeaderBox
extends FullBox {
    static byte[] TYPE = new byte[]{116, 107, 104, 100};
    static String TYPE_S = "tkhd";
    private long creationTime;
    private long modificationTime;
    private long duration;
    private long trackID;
    private int layer;
    private int alternateGroup;
    private float volume;
    private int[] matrix = new int[9];
    private double width;
    private double height;

    public TrackHeaderBox(long size) {
        super(size, TYPE_S);
    }

    protected int load(DataInputStream fin) throws IOException {
        super.load(fin);
        if (this.getVersion() == 1) {
            this.creationTime = this.read64(fin);
            this.modificationTime = this.read64(fin);
            this.trackID = fin.readInt();
            fin.readInt();
            this.duration = this.read64(fin);
        } else {
            this.creationTime = fin.readInt();
            this.modificationTime = fin.readInt();
            this.trackID = fin.readInt();
            fin.readInt();
            this.duration = fin.readInt();
        }
        fin.readInt();
        fin.readInt();
        this.layer = fin.readByte() << 8 | fin.readByte();
        this.alternateGroup = fin.readByte() << 8 | fin.readByte();
        this.volume = fin.readByte() + fin.readByte() / 10;
        fin.readByte();
        fin.readByte();
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = fin.readInt();
        }
        this.width = this.readFixedPoint1616(fin);
        this.height = this.readFixedPoint1616(fin);
        return (int)this.getSize();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getTrackID() {
        return this.trackID;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getAlternateGroup() {
        return this.alternateGroup;
    }

    public float getVolume() {
        return this.volume;
    }

    public int[] getMatrix() {
        return this.matrix;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

