/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.Box;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.CopyrightBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.MovieHintInformation;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TrackHintInformation;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.UndefinedBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDataBox
extends Box {
    static byte[] TYPE = new byte[]{117, 100, 116, 97};
    static String TYPE_S = "udta";
    private List<Box> userDefinedBoxes = new ArrayList<Box>();
    private boolean isTrackParent;

    public UserDataBox(long size, boolean isTrackParent) {
        super(size, TYPE_S);
        this.isTrackParent = isTrackParent;
    }

    @Override
    protected int load(DataInputStream fin) throws IOException {
        int count = 8;
        if (this.getSize() > 16L) {
            while ((long)(count + 8) < this.getSize()) {
                long len = this.readU32(fin);
                byte[] type = this.read(fin);
                Box box = null;
                if (this.comparebytes(type, CopyrightBox.TYPE)) {
                    box = new CopyrightBox(len);
                    count += box.load(fin);
                } else if (this.comparebytes(type, TrackHintInformation.TYPE) && this.isTrackParent) {
                    box = new TrackHintInformation(len);
                    count += box.load(fin);
                } else if (this.comparebytes(type, MovieHintInformation.TYPE)) {
                    box = new MovieHintInformation(len);
                    count += box.load(fin);
                } else {
                    box = new UndefinedBox(len, new String(type));
                    count += box.load(fin);
                }
                this.userDefinedBoxes.add(box);
            }
            if ((long)count < this.getSize()) {
                int skip = (int)this.getSize() - count;
                fin.skipBytes(skip);
            }
        } else {
            int skip = (int)this.getSize() - 8;
            fin.skipBytes(skip);
        }
        return (int)this.getSize();
    }

    public List<Box> getUserDefinedBoxes() {
        return this.userDefinedBoxes;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

