/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.video;

import java.io.IOException;
import java.net.URL;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.Utils;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.impl.resource.mediaplayer.video.MpegVideoTrackImpl;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Timer;
import org.mobicents.media.server.spi.resource.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoPlayerImpl
extends AbstractSource
implements Player {
    private static final Format[] FORMATS = new Format[]{AVProfile.MPEG4_GENERIC, AVProfile.MP4V};
    private Track track;
    private String videoMediaDirectory;

    public VideoPlayerImpl(String name, Timer timer, String videoMediaDirectory) {
        super(name);
        this.setSyncSource((SyncSource)timer);
        this.videoMediaDirectory = videoMediaDirectory;
    }

    public void setURL(String passedURI) throws IOException, ResourceUnavailableException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Component should be connected");
        }
        int pos = passedURI.lastIndexOf(46);
        if (pos == -1) {
            throw new IOException("Unknow file type: " + passedURI);
        }
        String ext = passedURI.substring(pos + 1).toLowerCase();
        try {
            URL targetURL = Utils.getAbsoluteURL((String)this.videoMediaDirectory, (String)passedURI);
            this.track = new MpegVideoTrackImpl(targetURL);
        }
        catch (Exception e) {
            throw new ResourceUnavailableException((Throwable)e);
        }
    }

    @Override
    public long getDuration() {
        return this.track.getDuration();
    }

    @Override
    public void setMediaTime(long timestamp) {
        this.track.setMediaTime(timestamp);
    }

    @Override
    public long getMediaTime() {
        return this.track.getMediaTime();
    }

    @Override
    public void start() {
        if (this.track == null) {
            throw new IllegalStateException("The media source is not specified");
        }
        super.start();
    }

    @Override
    public void stop() {
        if (this.track != null) {
            this.track.close();
            this.track = null;
        }
        super.stop();
    }

    @Override
    public void evolve(Buffer buffer, long timestamp) {
        try {
            this.track.process(buffer);
            buffer.setTimeStamp(timestamp);
            if (buffer.isEOM()) {
                this.track.close();
            }
        }
        catch (IOException e) {
            this.track.close();
            this.failed(10002, e);
            buffer.setDuration(0L);
        }
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        if (interfaceType.equals(Player.class)) {
            return (T)this;
        }
        return null;
    }
}

