/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.phone;

import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.spi.SyncSource;

public class PhoneSignalGenerator
extends AbstractSource {
    private static final AudioFormat LINEAR_AUDIO = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private static final Format[] FORMAT = new Format[]{LINEAR_AUDIO};
    private int[] f;
    private short A = Short.MAX_VALUE;
    private double dt;
    private int pSize;
    private double time;
    private double elapsed;
    private double duration;
    private double value = 1.0;
    private int[] T;

    public PhoneSignalGenerator(String name, SyncSource syncSource) {
        super(name);
        this.setSyncSource(syncSource);
        this.init();
    }

    private void init() {
        this.dt = 1.0 / LINEAR_AUDIO.getSampleRate();
    }

    public void setAmplitude(short A) {
        this.A = A;
    }

    public short getAmplitude() {
        return this.A;
    }

    public void setFrequency(int[] f) {
        this.f = f;
    }

    public int[] getFrequency() {
        return this.f;
    }

    public void setPeriods(int[] T) {
        this.T = T;
        this.duration = T[0];
    }

    public int[] getPeriods() {
        return this.T;
    }

    private short getValue(double t) {
        this.elapsed += this.dt;
        if (this.elapsed > this.duration) {
            if (this.value == 0.0) {
                this.value = 1.0;
                this.duration = this.T[0];
            } else {
                this.value = 0.0;
                this.duration = this.T[1];
            }
            this.elapsed = 0.0;
        }
        if (this.value == 0.0) {
            return 0;
        }
        double v = 0.0;
        for (int i = 0; i < this.f.length; ++i) {
            v += Math.sin(Math.PI * 2 * (double)this.f[i] * t);
        }
        return (short)(v * (double)this.A);
    }

    public void evolve(Buffer buffer, long timestamp) {
        int frameSize = (int)(0.02 / this.dt);
        byte[] data = new byte[2 * frameSize];
        int k = 0;
        this.pSize = (int)(0.02 / this.dt);
        for (int i = 0; i < frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        buffer.setData(data);
        buffer.setOffset(0);
        buffer.setLength(frameSize);
        buffer.setDuration(20L);
        buffer.setFormat((Format)LINEAR_AUDIO);
        buffer.setTimeStamp(timestamp);
        this.time += 0.02;
    }

    public Format[] getFormats() {
        return FORMAT;
    }
}

