/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.prelay;

import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.dsp.DspFactory;
import org.mobicents.media.server.impl.dsp.Processor;
import org.mobicents.media.server.impl.resource.cnf.AudioMixer;
import org.mobicents.media.server.spi.clock.Timer;

public class AudioChannel {
    private Processor p1;
    private Processor p2;
    private AudioMixer mixer;

    public AudioChannel(DspFactory dspFactory, Timer timer) {
        this.p1 = (Processor)dspFactory.newInstance(null);
        this.p2 = (Processor)dspFactory.newInstance(null);
        this.mixer = new AudioMixer("PacketRelay", timer);
        this.p1.getOutput().connect((MediaSink)this.mixer);
        this.p2.getInput().connect(this.mixer.getOutput());
    }

    public MediaSink getInput() {
        return this.p1.getInput();
    }

    public MediaSource getOutput() {
        return this.p2.getOutput();
    }

    public void connect(MediaSource source) {
        source.connect(this.p1.getInput());
    }

    public void disconnect(MediaSource source) {
        source.disconnect(this.p1.getInput());
    }

    public void connect(MediaSink sink) {
        this.p2.getOutput().connect(sink);
    }

    public void disconnect(MediaSink sink) {
        this.p2.getOutput().disconnect(sink);
    }

    public void stop() {
        this.mixer.stop();
    }
}

