/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.prelay;

import java.io.IOException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.Inlet;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.Outlet;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.TimerTask;

public class PacketRelay
extends BaseComponent
implements Inlet,
Outlet {
    private static final Format[] FORMATS = new Format[]{Format.ANY};
    private Input input;
    private Output output;
    private Buffer buff;
    private long timestamp;

    public PacketRelay(String name) {
        super(name);
        this.input = new Input(name);
        this.output = new Output(name);
        this.output.setSyncSource(this.input);
    }

    public void start() {
        this.input.start();
        this.output.start();
    }

    public void stop() {
        this.input.stop();
        this.output.stop();
    }

    public MediaSink getInput() {
        return this.input;
    }

    public MediaSource getOutput() {
        return this.output;
    }

    public void connect(MediaSource source) {
        this.input.connect(source);
    }

    public void disconnect(MediaSource source) {
        this.input.disconnect(source);
    }

    public void connect(MediaSink sink) {
        this.output.connect(sink);
    }

    public void disconnect(MediaSink sink) {
        this.output.disconnect(sink);
    }

    private class Output
    extends AbstractSource {
        public Output(String name) {
            super(name + "[output]");
        }

        public void start() {
        }

        public void stop() {
        }

        public void evolve(Buffer buffer, long timestamp) {
            buffer.copy(PacketRelay.this.buff);
        }

        public Format[] getOtherPartyFormats() {
            return this.otherParty != null ? this.otherParty.getFormats() : new Format[]{};
        }

        public Format[] getFormats() {
            return PacketRelay.this.input.isConnected() ? PacketRelay.this.input.getOtherPartyFormats() : new Format[]{};
        }
    }

    private class Input
    extends AbstractSink
    implements SyncSource {
        public Input(String name) {
            super(name + "[input]");
        }

        public void onMediaTransfer(Buffer buffer) throws IOException {
            PacketRelay.this.buff = buffer;
            PacketRelay.this.timestamp = buffer.getTimeStamp();
            PacketRelay.this.output.perform();
        }

        public Format[] getFormats() {
            return PacketRelay.this.output.isConnected() ? PacketRelay.this.output.getOtherPartyFormats() : FORMATS;
        }

        public Format[] getOtherPartyFormats() {
            return this.otherParty != null ? this.otherParty.getFormats() : new Format[]{};
        }

        public void sync(MediaSource mediaSource) {
        }

        public void unsync(MediaSource mediaSource) {
        }

        public long getTimestamp() {
            return PacketRelay.this.timestamp;
        }

        public TimerTask sync(Task task) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

