/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.ss7;

import org.mobicents.media.server.impl.resource.ss7.HdlcState;

public class FastHDLC {
    public static final int RETURN_COMPLETE_FLAG = 4096;
    public static final int RETURN_DISCARD_FLAG = 8192;
    public static final int RETURN_EMPTY_FLAG = 16384;
    public static final int FRAME_SEARCH = 0;
    public static final int PROCESS_FRAME = 1;
    private int[] hdlc_search = new int[256];
    public static final int CONTROL_COMPLETE = 1;
    public static final int CONTROL_ABORT = 2;
    public static final int STATUS_MASK = 32768;
    public static final int STATUS_VALID = 32768;
    public static final int STATUS_CONTROL = 0;
    public static final int STATE_MASK = 32768;
    public static final int ONES_MASK = 28672;
    public static final int DATA_MASK = 255;
    private int[][] hdlc_frame = new int[6][1024];
    private int[] minbits = new int[]{8, 10};
    private int[][] hdlc_encode = new int[6][256];

    private int hdlc_search_precalc(int c) {
        int p = 0;
        if (c == 126) {
            return 24;
        }
        if (c == 127) {
            return 8;
        }
        if (c == 255) {
            return 8;
        }
        int x = 1;
        for (p = 7; p != 0 && (c & x) != 0; --p) {
            x <<= 1;
        }
        return p;
    }

    private int HFP(int status, int ones, int bits, int data) {
        return status | ones << 12 | bits << 8 | data;
    }

    private int hdlc_frame_precalc(int x, int c) {
        int ones = x;
        int data = 0;
        int bits = 0;
        int consumed = 0;
        while (bits < 8) {
            data >>>= 1;
            ++consumed;
            if (ones == 5) {
                if ((c & 0x200) != 0) {
                    if ((c & 0x100) == 0 && bits == 6) {
                        return this.HFP(0, 0, 8, 1);
                    }
                    return this.HFP(0, 0, consumed + 1, 2);
                }
                ones = 0;
                data <<= 1;
            } else {
                if ((c & 0x200) != 0) {
                    data |= 0x80;
                    ++ones;
                } else {
                    ones = 0;
                }
                ++bits;
            }
            c <<= 1;
        }
        if (ones == 5) {
            ones = 0;
            ++consumed;
        }
        return this.HFP(32768, ones, consumed, data);
    }

    private int hdlc_encode_precalc(int x, int y) {
        int bits = 0;
        int ones = x;
        int data = 0;
        for (int z = 0; z < 8; ++z) {
            if (ones == 5) {
                data <<= 1;
                ones = 0;
                ++bits;
            }
            if ((y & 1) != 0) {
                data <<= 1;
                data |= 1;
                ++ones;
                ++bits;
            } else {
                data <<= 1;
                ones = 0;
                ++bits;
            }
            y >>= 1;
        }
        if (ones == 5) {
            data <<= 1;
            ones = 0;
            ++bits;
        }
        return (data <<= 10 - bits) << 22 | ones << 8 | bits;
    }

    public void fasthdlc_precalc() {
        int y;
        int x;
        for (x = 0; x < 256; ++x) {
            this.hdlc_search[x] = this.hdlc_search_precalc(x);
        }
        for (x = 0; x < 6; ++x) {
            for (y = 0; y < 1024; ++y) {
                this.hdlc_frame[x][y] = this.hdlc_frame_precalc(x, y);
            }
        }
        for (x = 0; x < 6; ++x) {
            for (y = 0; y < 256; ++y) {
                this.hdlc_encode[x][y] = this.hdlc_encode_precalc(x, y);
            }
        }
    }

    public void fasthdlc_init(HdlcState h) {
        h.state = 0;
        h.bits = 0;
        h.data = 0;
        h.ones = 0;
    }

    public int fasthdlc_tx_load_nocheck(HdlcState h, int c) {
        int res = this.hdlc_encode[h.ones][c];
        h.ones = (res & 0xF00) >> 8;
        h.data |= (res & 0xFFC00000) >>> h.bits;
        h.bits += res & 0xF;
        return 0;
    }

    public int fasthdlc_tx_load(HdlcState h, int c) {
        if (h.bits > 22) {
            return -1;
        }
        return this.fasthdlc_tx_load_nocheck(h, c);
    }

    public int fasthdlc_tx_frame_nocheck(HdlcState h) {
        h.ones = 0;
        h.data |= 0x7E000000 >> h.bits;
        h.bits += 8;
        return 0;
    }

    public int fasthdlc_tx_frame(HdlcState h) {
        if (h.bits > 24) {
            return -1;
        }
        return this.fasthdlc_tx_frame_nocheck(h);
    }

    public int fasthdlc_tx_run_nocheck(HdlcState h) {
        int b = h.data >> 24;
        h.bits -= 8;
        h.data <<= 8;
        return b;
    }

    public int fasthdlc_tx_run(HdlcState h) {
        if (h.bits < 8) {
            return -1;
        }
        return this.fasthdlc_tx_run_nocheck(h);
    }

    public int fasthdlc_rx_load_nocheck(HdlcState h, int b) {
        h.data |= b << 24 - h.bits;
        h.bits += 8;
        return 0;
    }

    public int fasthdlc_rx_load(HdlcState h, int b) {
        if (h.bits > 24) {
            return -1;
        }
        return this.fasthdlc_rx_load_nocheck(h, b);
    }

    public int fasthdlc_rx_run(HdlcState h) {
        int retval = 16384;
        while (h.bits >= this.minbits[h.state] && retval == 16384) {
            block0 : switch (h.state) {
                case 0: {
                    int next = this.hdlc_search[h.data >> 24 & 0xFF];
                    h.bits -= next & 0xF;
                    h.data <<= next & 0xF;
                    h.state = next >> 4 & 0xFF;
                    h.ones = 0;
                    break;
                }
                case 1: {
                    int next = this.hdlc_frame[h.ones][h.data >>> 22 & 0x3FF];
                    h.bits -= (next & 0xF00) >> 8 & 0xFF;
                    h.data <<= (next & 0xF00) >> 8 & 0xFF;
                    h.state = (next & 0x8000) >> 15 & 0xFF;
                    h.ones = (next & 0x7000) >> 12 & 0xFF;
                    switch (next & 0x8000) {
                        case 0: {
                            if ((next & 1) != 0) {
                                retval = 4096;
                                h.state = 1;
                                break block0;
                            }
                            retval = 8192;
                            break block0;
                        }
                        case 32768: {
                            retval = next & 0xFF;
                        }
                    }
                }
            }
        }
        return retval;
    }
}

