/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.ss7;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.media.server.impl.resource.ss7.FastHDLC;
import org.mobicents.media.server.impl.resource.ss7.HdlcState;
import org.mobicents.media.server.impl.resource.ss7.TxQueue;
import org.mobicents.media.server.spi.resource.ss7.LinkSet;
import org.mobicents.media.server.spi.resource.ss7.Mtp1;
import org.mobicents.media.server.spi.resource.ss7.Mtp2;
import org.mobicents.media.server.spi.resource.ss7.Mtp2Listener;
import org.mobicents.media.server.spi.resource.ss7.Mtp3;
import org.mobicents.media.server.spi.resource.ss7.Utils;

public class Mtp2Impl
implements Mtp2 {
    private static final int T2_TIMEOUT = 5000;
    private static final int T3_TIMEOUT = 2000;
    private static final int T4_TIMEOUT_NORMAL = 9500;
    private static final int T4_TIMEOUT_EMERGENCY = 500;
    private int T4_TIMEOUT = 9500;
    private int T7_TIMEOUT = 2000;
    private static final int T17_TIMEOUT = 1500;
    private static final int[] fcstab = new int[]{0, 4489, 8978, 12955, 17956, 22445, 25910, 29887, 35912, 40385, 44890, 48851, 51820, 56293, 59774, 63735, 4225, 264, 13203, 8730, 22181, 18220, 30135, 25662, 40137, 36160, 49115, 44626, 56045, 52068, 63999, 59510, 8450, 12427, 528, 5017, 26406, 30383, 17460, 21949, 44362, 48323, 36440, 40913, 60270, 64231, 51324, 55797, 12675, 8202, 4753, 792, 30631, 26158, 21685, 17724, 48587, 44098, 40665, 36688, 64495, 60006, 55549, 51572, 16900, 21389, 24854, 28831, 1056, 5545, 10034, 14011, 52812, 57285, 60766, 64727, 34920, 39393, 43898, 47859, 21125, 17164, 29079, 24606, 5281, 1320, 14259, 9786, 57037, 53060, 64991, 60502, 39145, 35168, 48123, 43634, 25350, 29327, 16404, 20893, 9506, 13483, 1584, 6073, 61262, 65223, 52316, 56789, 43370, 47331, 35448, 39921, 29575, 25102, 20629, 16668, 13731, 9258, 5809, 1848, 65487, 60998, 56541, 52564, 47595, 43106, 39673, 35696, 33800, 38273, 42778, 46739, 49708, 54181, 57662, 61623, 2112, 6601, 11090, 15067, 20068, 24557, 28022, 31999, 38025, 34048, 47003, 42514, 53933, 49956, 61887, 57398, 6337, 2376, 15315, 10842, 24293, 20332, 32247, 27774, 42250, 46211, 34328, 38801, 58158, 62119, 49212, 53685, 10562, 14539, 2640, 7129, 28518, 32495, 19572, 24061, 46475, 41986, 38553, 34576, 62383, 57894, 53437, 49460, 14787, 10314, 6865, 2904, 32743, 28270, 23797, 19836, 50700, 55173, 58654, 62615, 32808, 37281, 41786, 45747, 19012, 23501, 26966, 30943, 3168, 7657, 12146, 16123, 54925, 50948, 62879, 58390, 37033, 33056, 46011, 41522, 23237, 19276, 31191, 26718, 7393, 3432, 16371, 11898, 59150, 63111, 50204, 54677, 41258, 45219, 33336, 37809, 27462, 31439, 18516, 23005, 11618, 15595, 3696, 8185, 63375, 58886, 54429, 50452, 45483, 40994, 37561, 33584, 31687, 27214, 22741, 18780, 15843, 11370, 7921, 3960};
    public static final int RX_TX_BUFF_SIZE = 64;
    private static final int FRAME_STATUS_INDICATION_O = 0;
    private static final int FRAME_STATUS_INDICATION_N = 1;
    private static final int FRAME_STATUS_INDICATION_E = 2;
    private static final int FRAME_STATUS_INDICATION_OS = 3;
    private static final int FRAME_STATUS_INDICATION_PO = 4;
    private static final int FRAME_STATUS_INDICATION_B = 5;
    private static final int FRAME_FISU = 6;
    private static final String[] _FRAME_NAMES = new String[]{"SIO", "SIN", "SIE", "SIOS", "SIPO", "SIPB", "FISU"};
    public static final int AERM_THRESHOLD_NORMAL = 4;
    public static final int AERM_THRESHOLD_EMERGENCY = 1;
    private static final String[] _STATE_NAMES = new String[]{"OUT_OF_SERVICE", "NOT_ALIGNED", "ALIGNED", "PROVING", "ALIGNED_READY", "IN_SERVICE"};
    private int state;
    private Mtp1 layer1;
    private Mtp3 layer3;
    private LinkSet linkSet;
    private ArrayList<Mtp2Listener> listeners = new ArrayList();
    private volatile boolean started;
    private FastHDLC hdlc = new FastHDLC();
    private HdlcState rxState = new HdlcState();
    private HdlcState txState = new HdlcState();
    private int rxLen = 0;
    private int txLen = 0;
    private int txOffset = 0;
    private byte[] txBuffer = new byte[64];
    private byte[] rxBuffer = new byte[64];
    private int[] rxFrame = new int[279];
    private byte[] txFrame = new byte[279];
    private long lastWriteStamp = 0L;
    private TxQueue txQueue = new TxQueue();
    private int doCRC = 0;
    private int rxCRC = 65535;
    private int txCRC = 65535;
    private Mtp2SendBuffer[] transmissionBuffer = new Mtp2SendBuffer[128];
    private static final int _OFF_RTR = -1;
    private int retransmissionFSN = -1;
    private int retransmissionFSN_LastAcked = 0;
    private int retransmissionFSN_LastSent = 0;
    private int sendFIB;
    private int sendBSN;
    private int sendBIB;
    private int bsnErrors = 0;
    private String name;
    private int aermThreshold;
    private boolean aermEnabled;
    private boolean emergency = false;
    private static final int _PROVING_ATTEMPTS_THRESHOLD = 5;
    private int provingAttempts;
    private boolean futureProving;
    private int nCount;
    private int dCount;
    private int eCount;
    private byte sls = (byte)-1;
    private int subservice = -1;
    private AtomicInteger sltmTries = new AtomicInteger(0);
    private T2Action t2Action = new T2Action();
    private ScheduledFuture T2;
    private T3Action t3Action = new T3Action();
    private ScheduledFuture T3;
    private T4Action t4Action = new T4Action();
    private ScheduledFuture T4;
    private T7Action t7Action = new T7Action();
    private ScheduledFuture T7;
    private T17Action t17Action = new T17Action();
    private ScheduledFuture T17;
    private ScheduledExecutorService mtpTimer = Utils.getMtpTimer();
    private Runnable t1Action_SLTM = null;
    private Runnable t2Action_SLTM = null;
    private ScheduledFuture T1_SLTM;
    private ScheduledFuture T2_SLTM;
    private boolean enableDataTrace = false;
    private boolean enableSuTrace = false;
    private boolean enabledL2Debug = false;
    private static final Logger logger = Logger.getLogger(Mtp2Impl.class);

    public Mtp2Impl(String name) {
        this(name, -1, -1);
    }

    public Mtp2Impl(String name, byte sls) {
        this(name, sls, -1);
    }

    public Mtp2Impl(String name, byte sls, int subservice) {
        this.name = name;
        this.sls = sls;
        this.subservice = subservice;
        this.hdlc.fasthdlc_precalc();
        this.hdlc.fasthdlc_init(this.rxState);
        this.hdlc.fasthdlc_init(this.txState);
        this.aermThreshold = 4;
        for (int i = 0; i < this.transmissionBuffer.length; ++i) {
            this.transmissionBuffer[i] = new Mtp2SendBuffer();
        }
    }

    public void setLinkSet(LinkSet linkSet) {
        this.linkSet = linkSet;
        this.listeners.add(0, (Mtp2Listener)linkSet);
    }

    public LinkSet getLinkSet() {
        return this.linkSet;
    }

    public boolean isEmergency() {
        return this.emergency;
    }

    public void setEmergency(boolean emergency) {
        this.emergency = emergency;
    }

    public void restartSltmTries() {
        this.sltmTries.set(0);
    }

    public int incrementSltmTries() {
        return this.sltmTries.incrementAndGet();
    }

    public int getSltmTries() {
        return this.sltmTries.get();
    }

    public byte getSls() {
        return this.sls;
    }

    public int getState() {
        return this.state;
    }

    public int getSubService() {
        return this.subservice;
    }

    public void setSubService(int subservice) {
        this.subservice = subservice;
    }

    public void setLayer1(Mtp1 layer1) {
        this.layer1 = layer1;
    }

    public void setLayer3(Mtp3 layer3) {
        this.layer3 = layer3;
        this.listeners.add((Mtp2Listener)layer3);
    }

    public void _startLink() throws IOException {
        if (this.layer1 == null) {
            throw new IllegalStateException("Layer1 is not set in Layer2!");
        }
        if (this.started) {
            throw new IllegalStateException("Link already running");
        }
        this.layer1.open();
        this.started = true;
        this.reset();
        if (this.enabledL2Debug) {
            this.trace("Is out fo service now");
        }
        this.state = 0;
    }

    public void _stopLink() {
        this.started = false;
        this.reset();
        this.layer1.close();
    }

    public void _closeLink() {
        this._stopLink();
        this.layer1 = null;
    }

    private void startInitialAlignment() {
        this.startInitialAlignment(true);
    }

    protected void startInitialAlignment(boolean resetTxOffset) {
        if (resetTxOffset) {
            this.txOffset = 3;
        }
        this.reset();
        if (this.enabledL2Debug) {
            this.trace(" Starting IAM procedure");
        }
        this.state = 1;
        this.start_T2();
    }

    private void reset() {
        this.nCount = 0;
        this.eCount = 0;
        this.dCount = 0;
        this.sendFIB = 1;
        this.sendBSN = 127;
        this.sendBIB = 1;
        this.retransmissionFSN = -1;
        this.retransmissionFSN_LastAcked = 127;
        this.retransmissionFSN_LastSent = 127;
    }

    public void failLink() {
        this.cleanupTimers();
        this.state = 0;
    }

    public boolean queue(byte[] msg) {
        if (this.state != 5) {
            if (this.enableSuTrace && this.enabledL2Debug) {
                this.trace("MTP3 scheduled MSU when not in service, discarding.");
            }
            return false;
        }
        int possibleFSN = Mtp2Impl.NEXT_FSN(this.retransmissionFSN_LastSent);
        if (possibleFSN == this.retransmissionFSN_LastAcked) {
            if (this.enableSuTrace && this.enabledL2Debug) {
                this.trace("Failed to queue msg, transmission buffer is full.");
            }
            return false;
        }
        this.transmissionBuffer[possibleFSN].frame[0] = 0;
        this.transmissionBuffer[possibleFSN].frame[1] = 0;
        this.transmissionBuffer[possibleFSN].frame[2] = (byte)(msg.length >= 63 ? 63 : msg.length);
        System.arraycopy(msg, 0, this.transmissionBuffer[possibleFSN].frame, 3, msg.length);
        this.transmissionBuffer[possibleFSN].len = 3 + msg.length;
        if (this.enableSuTrace && this.enabledL2Debug) {
            this.trace("Queue MSU");
        }
        this.retransmissionFSN_LastSent = possibleFSN;
        if (this.retransmissionFSN == -1) {
            this.retransmissionFSN = possibleFSN;
        }
        this.start_T7();
        return true;
    }

    private void queueLSSU(int indicator) {
        if (this.txLen != this.txOffset) {
            byte[] frame = new byte[]{(byte)(this.sendBSN | this.sendBIB << 7), (byte)(this.retransmissionFSN_LastSent | this.sendFIB << 7), 1, (byte)indicator};
            this.txQueue.offer(frame);
        } else {
            this.txLen = 4;
            this.txFrame[0] = (byte)(this.sendBSN | this.sendBIB << 7);
            this.txFrame[1] = (byte)(this.retransmissionFSN_LastSent | this.sendFIB << 7);
            this.txFrame[2] = 1;
            this.txFrame[3] = (byte)indicator;
        }
        if (this.enableSuTrace && this.enabledL2Debug) {
            this.trace("Queue LSSU[" + _FRAME_NAMES[indicator] + "]");
        }
    }

    private void queueFISU() {
        this.txLen = 3;
        this.txFrame[0] = (byte)(this.sendBSN | this.sendBIB << 7);
        this.txFrame[1] = (byte)(this.retransmissionFSN_LastSent | this.sendFIB << 7);
        this.txFrame[2] = 0;
        if (this.enableSuTrace && this.enabledL2Debug) {
            this.trace("Queue FISU");
        }
    }

    private void queueNextFrame() {
        if (this.state != 5 && !this.txQueue.isEmpty()) {
            byte[] b = this.txQueue.peak();
            System.arraycopy(b, 0, this.txFrame, 0, b.length);
            this.txLen = b.length;
        } else {
            switch (this.state) {
                case 0: {
                    this.queueLSSU(3);
                    break;
                }
                case 1: {
                    this.queueLSSU(0);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.emergency) {
                        this.queueLSSU(2);
                        break;
                    }
                    this.queueLSSU(1);
                    break;
                }
                default: {
                    if (this.retransmissionFSN != -1) {
                        Mtp2SendBuffer buffer = this.transmissionBuffer[this.retransmissionFSN];
                        System.arraycopy(buffer.frame, 0, this.txFrame, 0, buffer.len);
                        this.txLen = buffer.len;
                        this.txFrame[0] = (byte)(this.sendBSN | this.sendBIB << 7);
                        this.txFrame[1] = (byte)(this.retransmissionFSN | this.sendFIB << 7);
                        this.retransmissionFSN = this.retransmissionFSN == this.retransmissionFSN_LastSent ? -1 : Mtp2Impl.NEXT_FSN(this.retransmissionFSN);
                        return;
                    }
                    this.queueFISU();
                }
            }
        }
    }

    public static final int PPP_FCS(int fcs, int c) {
        return fcs >> 8 ^ fcstab[(fcs ^ c) & 0xFF];
    }

    private void processLssu(int fsn, int bsn) {
        int type = this.rxFrame[3] & 7;
        block0 : switch (this.state) {
            case 1: {
                switch (type) {
                    case 0: 
                    case 1: {
                        this.stop_T2();
                        if (this.emergency) {
                            this.T4_TIMEOUT = 500;
                            this.queueLSSU(2);
                        } else {
                            this.T4_TIMEOUT = 9500;
                            this.queueLSSU(1);
                        }
                        this.start_T3();
                        this.state = 2;
                        break block0;
                    }
                    case 2: {
                        this.stop_T2();
                        this.T4_TIMEOUT = 500;
                        if (this.emergency) {
                            this.queueLSSU(2);
                        } else {
                            this.queueLSSU(1);
                        }
                        this.start_T3();
                        this.state = 2;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (type) {
                    case 2: {
                        this.T4_TIMEOUT = 500;
                    }
                    case 1: {
                        this.stop_T3();
                        if (this.T4_TIMEOUT == 500) {
                            this.aermThreshold = 1;
                        }
                        this.startAERM();
                        this.start_T4();
                        this.provingAttempts = 0;
                        this.futureProving = false;
                        this.state = 3;
                        break block0;
                    }
                    case 3: {
                        this.stop_T3();
                        this.alignmentNotPossible("Receievd SIOS in state ALIGNED");
                        this.emergency = false;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (type) {
                    case 0: {
                        this.stop_T4();
                        this.stopAERM();
                        this.start_T3();
                        this.state = 2;
                        break block0;
                    }
                    case 2: {
                        if (this.T4_TIMEOUT == 500) {
                            return;
                        }
                        this.stop_T4();
                        this.stopAERM();
                        this.aermThreshold = 1;
                        this.startAERM();
                        this.futureProving = false;
                        this.start_T4();
                        break block0;
                    }
                    case 3: {
                        this.stop_T4();
                        this.alignmentNotPossible("Received SIOS in state PROVING");
                        this.stopAERM();
                        this.emergency = false;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (type) {
                    case 0: {
                        this.alignmentNotPossible("Received SIO in state ALIGNED_READY");
                        break;
                    }
                    case 3: {
                        this.alignmentNotPossible("Received SIOS in state ALIGNED_READY");
                    }
                }
                break;
            }
            case 5: {
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.alignmentNotPossible("Received " + _FRAME_NAMES[type] + " in state IN_SERVICE");
                        break;
                    }
                    case 3: {
                        this.alignmentNotPossible("Received SIOS in state IN_SERVICE");
                    }
                }
                break;
            }
        }
    }

    private void processMSU(int len) {
        if (this.layer3 != null) {
            int sio = this.rxFrame[3];
            int realLength = 0;
            realLength = len == 63 ? this.rxLen - 6 : len - 1;
            byte[] sif = new byte[realLength];
            for (int i = 0; i < realLength; ++i) {
                sif[i] = (byte)this.rxFrame[i + 4];
            }
            this.layer3.onMessage(sio, sif, (Mtp2)this);
        }
    }

    private void processFrame() {
        int bsn = this.rxFrame[0] & 0x7F;
        int bib = this.rxFrame[0] >> 7 & 1;
        int fsn = this.rxFrame[1] & 0x7F;
        int fib = this.rxFrame[1] >> 7 & 1;
        int li = this.rxFrame[2] & 0x3F;
        if (this.enableSuTrace && this.enabledL2Debug) {
            String type = null;
            if (li == 0) {
                type = "FISU(";
            } else if (li == 1 || li == 2) {
                int lssuType = this.rxFrame[3] & 7;
                type = "LSSU(" + _FRAME_NAMES[lssuType];
            } else {
                type = "MSU(";
            }
            StringBuilder sbb = new StringBuilder();
            sbb.append("Received frame, type = ").append(type).append(" sequencing, (fsn = ").append(fsn).append(", fib = ").append(fib).append(", bsn = ").append(bsn).append(", bib = ").append(bib).append(")");
            this.trace(sbb.toString());
        }
        if (li + 3 > this.rxLen) {
            if (this.enableSuTrace && this.enabledL2Debug) {
                this.trace("Discarding frame on wrong RX Len: " + this.rxLen + " > " + li);
            }
            return;
        }
        if (li == 1 || li == 2) {
            this.processLssu(fsn, bsn);
            return;
        }
        if (this.state != 5) {
            switch (this.state) {
                case 3: {
                    if (!this.futureProving) break;
                    this.startAERM();
                    this.futureProving = false;
                    this.start_T4();
                    break;
                }
                case 4: {
                    if (this.enabledL2Debug) {
                        this.trace("Received proper SU in ALIGNED_READY state, switching to IN_SERVICE.");
                    }
                    this.eCount = 0;
                    this.dCount = 0;
                    this.stop_T7();
                    this.sendFIB = bib;
                    this.sendBSN = fsn;
                    this.sendBIB = fib;
                    this.retransmissionFSN_LastAcked = bsn;
                    this.state = 5;
                    for (Mtp2Listener lst : this.listeners) {
                        lst.linkInService((Mtp2)this);
                    }
                    break;
                }
            }
        }
        if (this.retransmissionFSN_LastAcked <= this.retransmissionFSN_LastSent && (bsn < this.retransmissionFSN_LastAcked || bsn > this.retransmissionFSN_LastSent) || this.retransmissionFSN_LastAcked > this.retransmissionFSN_LastSent && bsn < this.retransmissionFSN_LastAcked && bsn > this.retransmissionFSN_LastSent) {
            ++this.bsnErrors;
            if (this.bsnErrors > 2) {
                this.bsnErrors = 0;
                for (Mtp2Listener lst : this.listeners) {
                    lst.linkFailed((Mtp2)this);
                }
                this.alignmentBroken("Broken BSN constrains: fsn_lasAcked = " + this.retransmissionFSN_LastAcked + ", fsn_LastSent = " + this.retransmissionFSN_LastSent + ", bsn = " + bsn);
            }
            return;
        }
        this.bsnErrors = 0;
        if (bib == this.sendFIB) {
            if (bsn != this.retransmissionFSN_LastAcked) {
                this.stop_T7();
                this.retransmissionFSN_LastAcked = bsn;
                if (this.retransmissionFSN_LastAcked != this.retransmissionFSN_LastSent) {
                    this.start_T7();
                }
            }
        } else {
            this.sendFIB = bib;
            this.retransmissionFSN = bsn == this.retransmissionFSN_LastSent ? -1 : Mtp2Impl.NEXT_FSN(bsn);
        }
        if (li == 0) {
            if (fsn != this.sendBSN && fib == this.sendBIB) {
                this.sendBIB = Mtp2Impl.NEXT_INDICATOR(this.sendBIB);
            }
        } else {
            if (fsn == this.sendBSN) {
                return;
            }
            if (fsn == Mtp2Impl.NEXT_FSN(this.sendBSN)) {
                if (fib != this.sendBIB) {
                    return;
                }
            } else {
                if (fib == this.sendBIB) {
                    this.sendBIB = Mtp2Impl.NEXT_INDICATOR(this.sendBIB);
                }
                return;
            }
            this.sendBSN = fsn;
            this.processMSU(li);
        }
    }

    private void processRx(byte[] buff, int len) {
        int i = 0;
        if (this.enableDataTrace && this.enabledL2Debug) {
            Utils.getInstance().addBuffer((int)this.sls, this.name, this.linkSet.getName(), (int)this.linkSet.getId(), System.currentTimeMillis(), buff, len);
        }
        block5: while (i < len) {
            while (this.rxState.bits <= 24 && i < len) {
                int b = buff[i++] & 0xFF;
                this.hdlc.fasthdlc_rx_load_nocheck(this.rxState, b);
                if (this.rxState.state != 0) continue;
                this.nCount = (this.nCount + 1) % 16;
                if (this.nCount != 0) continue;
                this.countError("on receive");
            }
            int res = this.hdlc.fasthdlc_rx_run(this.rxState);
            switch (res) {
                case 4096: {
                    this.countFrame();
                    if (this.rxLen != 0) {
                        if (this.rxLen < 5) {
                            this.countError("hdlc error, frame LI<5");
                        } else if (this.rxCRC == 61624) {
                            this.processFrame();
                        } else {
                            this.countError("hdlc complete, wrong terms.");
                        }
                    }
                    this.rxLen = 0;
                    this.rxCRC = 65535;
                    continue block5;
                }
                case 8192: {
                    this.rxCRC = 65535;
                    this.rxLen = 0;
                    this.countFrame();
                    this.countError("hdlc discard.");
                    continue block5;
                }
                case 16384: {
                    this.rxLen = 0;
                    continue block5;
                }
            }
            if (this.rxLen > 279) {
                this.rxState.state = 0;
                this.rxLen = 0;
                this.rxCRC = 65535;
                this.eCount = 0;
                this.countFrame();
                this.countError("Overlong MTP frame, entering octet mode on link '" + this.name + "'");
                continue;
            }
            this.rxFrame[this.rxLen++] = res;
            this.rxCRC = Mtp2Impl.PPP_FCS(this.rxCRC, res & 0xFF);
        }
    }

    private void processTx(int bytesRead) throws IOException {
        for (int i = 0; i < bytesRead && i < 64; ++i) {
            if (this.txState.bits < 8) {
                if (this.doCRC == 0 && this.txOffset < this.txLen) {
                    int data = this.txFrame[this.txOffset++] & 0xFF;
                    this.hdlc.fasthdlc_tx_load(this.txState, data);
                    this.txCRC = Mtp2Impl.PPP_FCS(this.txCRC, data);
                    if (this.txOffset == this.txLen) {
                        this.doCRC = 1;
                        this.txCRC ^= 0xFFFF;
                    }
                } else if (this.doCRC == 1) {
                    this.hdlc.fasthdlc_tx_load_nocheck(this.txState, this.txCRC & 0xFF);
                    this.doCRC = 2;
                } else if (this.doCRC == 2) {
                    this.hdlc.fasthdlc_tx_load_nocheck(this.txState, this.txCRC >> 8 & 0xFF);
                    this.doCRC = 0;
                } else {
                    this.queueNextFrame();
                    this.txOffset = 0;
                    this.txCRC = 65535;
                    this.hdlc.fasthdlc_tx_frame_nocheck(this.txState);
                }
            }
            this.txBuffer[i] = (byte)this.hdlc.fasthdlc_tx_run_nocheck(this.txState);
        }
    }

    public void threadTick(long tickTimeStamp) {
        if (this.started) {
            int bytesRead;
            block20: {
                bytesRead = 0;
                try {
                    bytesRead = this.layer1.read(this.rxBuffer);
                    if (bytesRead <= 0) break block20;
                    this.processRx(this.rxBuffer, bytesRead);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (this.enabledL2Debug) {
                        this.trace(Utils.createTrace((Throwable)e));
                    }
                    this.state = 0;
                    for (Mtp2Listener lst : this.listeners) {
                        lst.linkFailed((Mtp2)this);
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    if (this.enabledL2Debug) {
                        this.trace(Utils.createTrace((Throwable)ee));
                    }
                    this.state = 0;
                    for (Mtp2Listener lst : this.listeners) {
                        lst.linkFailed((Mtp2)this);
                    }
                }
            }
            try {
                long currentTime = System.currentTimeMillis();
                if (bytesRead > 0) {
                    this.processTx(bytesRead);
                    this.layer1.write(this.txBuffer, bytesRead);
                } else {
                    if (this.lastWriteStamp == 0L) {
                        this.lastWriteStamp = currentTime;
                        bytesRead = 16;
                    } else {
                        bytesRead = (int)(currentTime - this.lastWriteStamp);
                        if (bytesRead > 64) {
                            bytesRead = 64;
                        }
                    }
                    this.processTx(bytesRead);
                    this.layer1.write(this.txBuffer, bytesRead);
                }
                this.lastWriteStamp = currentTime;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.enabledL2Debug) {
                    this.trace(Utils.createTrace((Throwable)e));
                }
                this.state = 0;
                for (Mtp2Listener lst : this.listeners) {
                    lst.linkFailed((Mtp2)this);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                if (this.enabledL2Debug) {
                    this.trace(Utils.createTrace((Throwable)ee));
                }
                this.state = 0;
                for (Mtp2Listener lst : this.listeners) {
                    lst.linkFailed((Mtp2)this);
                }
            }
        }
    }

    private void stopAERM() {
        this.aermEnabled = false;
    }

    private void startAERM() {
        this.eCount = 0;
        this.nCount = 0;
        this.aermEnabled = true;
    }

    private void alignmentNotPossible(String cause) {
        this.cleanupTimers();
        this.reset();
        if (this.state == 5 && this.layer3 != null) {
            this.layer3.linkFailed((Mtp2)this);
        }
        this.state = 0;
        this.start_T17();
        if (this.enabledL2Debug) {
            this.trace("Alignment not possible, initiating T17 for restart. Cause: " + cause);
        }
    }

    private void alignmentBroken(String cause) {
        this.cleanupTimers();
        this.reset();
        if (this.state == 5 && this.layer3 != null) {
            this.layer3.linkFailed((Mtp2)this);
        }
        this.state = 0;
        this.start_T17();
        if (this.enabledL2Debug) {
            this.trace("Alignment broken, initiating T17 for restart. Cause: " + cause);
        }
    }

    private void cleanupTimers() {
        this.stop_T2();
        this.stop_T3();
        this.stop_T4();
        this.stop_T7();
        this.stop_T17();
    }

    private void alignmentComplete() {
        this.stop_T2();
        this.stop_T3();
        this.stop_T4();
        this.state = 4;
    }

    private void countError(String info) {
        ++this.eCount;
        switch (this.state) {
            case 4: 
            case 5: {
                if (this.eCount < 64) break;
                if (this.layer3 != null) {
                    this.layer3.linkFailed((Mtp2)this);
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (!this.aermEnabled || this.eCount < this.aermThreshold) break;
                ++this.provingAttempts;
                if (this.provingAttempts < 5) {
                    this.futureProving = true;
                    if (this.enabledL2Debug) {
                        this.trace("Exceeded AERM threshold[ " + this.aermThreshold + " ] errors[ " + this.eCount + " ], proving attempts[ " + this.provingAttempts + " ]");
                    }
                    return;
                }
                this.alignmentNotPossible("Exceeded AERM threshold[" + this.aermThreshold + "] errors[" + this.eCount + "], proving attempts[" + this.provingAttempts + "]");
                this.stop_T3();
                this.emergency = false;
                this.stopAERM();
            }
        }
    }

    private void countFrame() {
        if (this.state == 4 || this.state == 5) {
            this.dCount = (this.dCount + 1) % 256;
            if (this.dCount == 0 && this.eCount > 0) {
                --this.eCount;
            }
        }
    }

    private void start_T2() {
        this.stop_T2();
        this.T2 = this.mtpTimer.schedule(this.t2Action, 5000L, TimeUnit.MILLISECONDS);
    }

    private void stop_T2() {
        ScheduledFuture f = this.T2;
        if (f != null && !f.isCancelled()) {
            this.T2 = null;
            f.cancel(false);
        }
    }

    private void start_T3() {
        this.stop_T3();
        this.T3 = this.mtpTimer.schedule(this.t3Action, 2000L, TimeUnit.MILLISECONDS);
    }

    private void stop_T3() {
        ScheduledFuture f = this.T3;
        if (f != null && !f.isCancelled()) {
            this.T3 = null;
            f.cancel(false);
        }
    }

    private void start_T4() {
        this.stop_T4();
        this.T4 = this.mtpTimer.schedule(this.t4Action, (long)this.T4_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    private void stop_T4() {
        ScheduledFuture f = this.T4;
        if (f != null && !f.isCancelled()) {
            this.T4 = null;
            f.cancel(false);
        }
    }

    private void start_T7() {
        this.stop_T7();
        this.T7 = this.mtpTimer.schedule(this.t7Action, (long)this.T7_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    private void stop_T7() {
        ScheduledFuture f = this.T7;
        if (f != null && !f.isCancelled()) {
            this.T7 = null;
            f.cancel(false);
        }
    }

    public void start_T17() {
        this.stop_T17();
        this.T17 = this.mtpTimer.schedule(this.t17Action, 1500L, TimeUnit.MILLISECONDS);
    }

    public void stop_T17() {
        ScheduledFuture f = this.T17;
        if (f != null && !f.isCancelled()) {
            this.T17 = null;
            f.cancel(false);
        }
    }

    public boolean isT17() {
        return this.T17 != null;
    }

    public void stop_T1_SLTM() {
        ScheduledFuture f = this.T1_SLTM;
        if (f != null && !f.isCancelled()) {
            this.T1_SLTM = null;
            f.cancel(false);
        }
    }

    public void stop_T2_SLTM() {
        ScheduledFuture f = this.T2_SLTM;
        if (f != null && !f.isCancelled()) {
            this.T2_SLTM = null;
            f.cancel(false);
        }
    }

    public void start_T1_SLTM() {
        this.stop_T1_SLTM();
        this.T1_SLTM = this.mtpTimer.schedule(this.t1Action_SLTM, 12L, TimeUnit.SECONDS);
    }

    public void start_T2_SLTM() {
        this.stop_T2_SLTM();
        this.T2_SLTM = this.mtpTimer.schedule(this.t2Action_SLTM, 90L, TimeUnit.SECONDS);
    }

    public boolean isT1_SLTM() {
        return this.T1_SLTM != null;
    }

    public boolean isT2_SLTM() {
        return this.T2_SLTM != null;
    }

    public void setT1_SLTMTimerAction(Runnable r) {
        this.t1Action_SLTM = r;
    }

    public void setT2_SLTMTimerAction(Runnable r) {
        this.t2Action_SLTM = r;
    }

    public boolean isL2Debug() {
        return this.enabledL2Debug;
    }

    public void setL2Debug(boolean l2Debug) {
        this.enabledL2Debug = l2Debug;
    }

    public boolean isEnableDataTrace() {
        return this.enableDataTrace;
    }

    public void setEnableDataTrace(boolean enableDataTrace) {
        this.enableDataTrace = enableDataTrace;
    }

    public boolean isEnableSuTrace() {
        return this.enableSuTrace;
    }

    public void setEnableSuTrace(boolean enableSuTrace) {
        this.enableSuTrace = enableSuTrace;
    }

    public void trace(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(System.currentTimeMillis()).append(" Link [").append(this.name).append("] [").append(" state = ").append(_STATE_NAMES[this.state]).append(" ]").append(" fsn = ").append(this.retransmissionFSN_LastSent).append(", fsn_acked = ").append(this.retransmissionFSN_LastAcked).append(", rtrFSN = ").append(this.retransmissionFSN).append(", fib = ").append(this.sendFIB).append(", bsn = ").append(this.sendBSN).append(", bib = ").append(this.sendBIB).append(") ").append(msg);
        Utils.getInstance().append(sb.toString());
    }

    private static final int NEXT_FSN(int x) {
        return ((x & 0x7F) + 1) % 128;
    }

    private static final int NEXT_INDICATOR(int x) {
        return (x + 1) % 2;
    }

    private class Mtp2SendBuffer {
        byte[] frame = new byte[279];
        int len = 0;

        private Mtp2SendBuffer() {
        }
    }

    private class T17Action
    implements Runnable {
        private boolean initial = true;

        private T17Action() {
        }

        public void run() {
            if (logger.isEnabledFor((Priority)Level.WARN) && Mtp2Impl.this.enabledL2Debug) {
                Mtp2Impl.this.trace("-------- Restarting alignment '" + Mtp2Impl.this.name + "'-----------");
            }
            Mtp2Impl.this.stop_T17();
            if (Mtp2Impl.this.state == 0) {
                Mtp2Impl.this.startInitialAlignment(this.initial);
            }
            if (this.initial) {
                this.initial = false;
            }
        }
    }

    private class T7Action
    implements Runnable {
        private T7Action() {
        }

        public void run() {
            Mtp2Impl.this.stop_T7();
        }
    }

    private class T4Action
    implements Runnable {
        private T4Action() {
        }

        public void run() {
            Mtp2Impl.this.stop_T4();
            int tmpState = Mtp2Impl.this.state;
            if (tmpState == 3) {
                if (Mtp2Impl.this.futureProving) {
                    Mtp2Impl.this.startAERM();
                    Mtp2Impl.this.futureProving = false;
                    Mtp2Impl.this.start_T4();
                } else {
                    Mtp2Impl.this.alignmentComplete();
                }
            } else if (logger.isEnabledFor((Priority)Level.WARN) && Mtp2Impl.this.enabledL2Debug) {
                Mtp2Impl.this.trace("T4 fired in state[ " + _STATE_NAMES[tmpState] + " ]");
            }
        }
    }

    private class T3Action
    implements Runnable {
        private T3Action() {
        }

        public void run() {
            Mtp2Impl.this.stop_T3();
            int tmpState = Mtp2Impl.this.state;
            if (tmpState == 2) {
                Mtp2Impl.this.alignmentNotPossible("T3 Expired.");
                Mtp2Impl.this.emergency = false;
                if (logger.isEnabledFor((Priority)Level.WARN) && Mtp2Impl.this.enabledL2Debug) {
                    Mtp2Impl.this.trace("Timer T3 has expired, Alignment not possible. ");
                }
            } else if (logger.isEnabledFor((Priority)Level.WARN) && Mtp2Impl.this.enabledL2Debug) {
                Mtp2Impl.this.trace("T3 fired in state[ " + _STATE_NAMES[tmpState] + " ]");
            }
        }
    }

    private class T2Action
    implements Runnable {
        private T2Action() {
        }

        public void run() {
            Mtp2Impl.this.stop_T2();
            int tmpState = Mtp2Impl.this.state;
            if (tmpState == 1) {
                Mtp2Impl.this.alignmentNotPossible("T2 Expired.");
                Mtp2Impl.this.emergency = false;
                if (logger.isEnabledFor((Priority)Level.WARN) && Mtp2Impl.this.enabledL2Debug) {
                    Mtp2Impl.this.trace("Timer T2 has expired, Alignment not possible. ");
                }
            } else if (logger.isEnabledFor((Priority)Level.WARN) && Mtp2Impl.this.enabledL2Debug) {
                Mtp2Impl.this.trace("T2 fired in state[ " + _STATE_NAMES[tmpState] + " ]");
            }
        }
    }
}

