/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.ss7;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.media.server.spi.resource.ss7.LinkSet;
import org.mobicents.media.server.spi.resource.ss7.MTPThreadFactory;
import org.mobicents.media.server.spi.resource.ss7.Mtp2;
import org.mobicents.media.server.spi.resource.ss7.Mtp3;
import org.mobicents.media.server.spi.resource.ss7.SS7Layer4;
import org.mobicents.media.server.spi.resource.ss7.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mtp3Impl
implements Mtp3,
Runnable {
    private static final int LINK_MANAGEMENT = 0;
    private static final int LINK_TESTING = 1;
    private static final int SERVICE_SCCP = 3;
    private static final int SERVICE_ISUP = 5;
    protected SS7Layer4 layer4;
    protected List<LinkSet> linkSets = new ArrayList<LinkSet>();
    private final MTPThreadFactory mainThreadFactory;
    protected Thread _MAIN_THREAD = null;
    private final MTPThreadFactory processorThreadFactory;
    private final ScheduledExecutorService _PROCESSOR;
    private boolean l4IsUp = false;
    protected volatile boolean started = false;
    private static final int _SERVICE_SLTM = 0;
    private static final int _SERVICE_TRA = 1;
    private static final int _DEFAULT_SUB_SERVICE_TRA = 12;
    private static final byte[] SLTM_PATTERN = new byte[]{1, 2, 3, 4, 5, 6, 15};
    protected String name;
    private Logger logger = Logger.getLogger(Mtp3Impl.class);
    private final int counter = 0;
    private static final int SIF_PATTERN_OFFSET = 6;
    private boolean l3Debug;

    public Mtp3Impl(String name) {
        this.name = name;
        this.mainThreadFactory = new MTPThreadFactory("MTP3TickThread[" + name + "]", 10);
        this.processorThreadFactory = new MTPThreadFactory("MTP3ProcessorThread[" + name + "]", 1);
        this._PROCESSOR = Executors.newSingleThreadScheduledExecutor((ThreadFactory)this.processorThreadFactory);
    }

    public void setLayer4(SS7Layer4 layer4) {
        this.layer4 = layer4;
    }

    public void setLinkSets(List<LinkSet> linkSets) {
        for (LinkSet ls : linkSets) {
            this.linkSets.add(ls);
            for (Mtp2 mtp2 : ls.getLinks()) {
                mtp2.setLayer3((Mtp3)this);
                T1Action_SLTM sltm1 = new T1Action_SLTM();
                T2Action_SLTM sltm2 = new T2Action_SLTM();
                sltm1.mtp2 = mtp2;
                sltm2.mtp2 = mtp2;
                mtp2.setT1_SLTMTimerAction((Runnable)sltm1);
                mtp2.setT2_SLTMTimerAction((Runnable)sltm2);
            }
        }
        Collections.sort(this.linkSets, new LinkSetComparator());
        for (int i = 0; i < this.linkSets.size(); ++i) {
            LinkSet ls;
            ls = this.linkSets.get(i);
            if (i == ls.getId()) continue;
            throw new IllegalArgumentException("Linkset ID[" + ls.getId() + "] of link[" + ls.getName() + "] does not equal index, change id to be in range of linkset count <0,n-1>.");
        }
    }

    public void start() throws IOException {
        Utils.getInstance().startDebug();
        for (LinkSet ls : this.linkSets) {
            for (Mtp2 mtp2 : ls.getLinks()) {
                mtp2._startLink();
            }
        }
        this.manageLinkSet();
        this.started = true;
        this._MAIN_THREAD = this.mainThreadFactory.newThread((Runnable)this);
        this._MAIN_THREAD.start();
    }

    public void stop() {
        this.started = false;
        for (LinkSet ls : this.linkSets) {
            for (Mtp2 mtp2 : ls.getLinks()) {
                mtp2._stopLink();
            }
        }
        this._MAIN_THREAD.stop();
        Utils.getInstance().stopDebug();
    }

    @Override
    public void run() {
        while (this.started) {
            try {
                long thisTickStamp = System.currentTimeMillis();
                for (LinkSet ls : this.linkSets) {
                    ls.threadTick(thisTickStamp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onMessage(int sio, byte[] sif, Mtp2 mtp2) {
        ProcessorClass pc = new ProcessorClass();
        pc.sio = sio;
        ProcessorClass.access$702(pc, sif);
        pc.mtp2 = mtp2;
        this._PROCESSOR.execute(pc);
    }

    public boolean send(byte sls, byte linksetId, int service, int subservice, byte[] msg) {
        if (!this.l4IsUp) {
            return false;
        }
        Mtp2 mtp2 = this.findLink(sls, linksetId);
        byte[] buffer = new byte[5 + msg.length];
        this.writeRoutingLabel(buffer, mtp2);
        buffer[0] = (byte)(service & 0xF | (subservice & 0xF) << 4);
        System.arraycopy(msg, 0, buffer, 5, msg.length);
        if (this.isL3Debug()) {
            mtp2.trace("Scheduling MSU: " + Utils.dump((byte[])buffer, (int)buffer.length, (boolean)false));
        }
        return mtp2.queue(buffer);
    }

    private Mtp2 findLink(byte sls, byte linksetId) {
        LinkSet ls = this.findLinkSet(linksetId);
        ArrayList activeLinksInLinkSet = ls.getActiveLinks();
        Mtp2 found = null;
        if (sls > 15 || sls < 0 || sls > activeLinksInLinkSet.size()) {
            if (this.isL3Debug()) {
                Utils.getInstance().append("Passed sls value[" + sls + "] is not good, determine arbitrary.");
            }
            int index = 0 % activeLinksInLinkSet.size();
            found = (Mtp2)activeLinksInLinkSet.get(index);
        } else {
            found = (Mtp2)activeLinksInLinkSet.get(sls);
        }
        return found;
    }

    private LinkSet findLinkSet(byte linksetId) {
        if (linksetId > this.linkSets.size() || linksetId < 0) {
            if (this.isL3Debug()) {
                Utils.getInstance().append("Passed linkset value[" + linksetId + "] is not good, determine arbitrary.");
            }
            linksetId = (byte)(linksetId % this.linkSets.size());
        }
        return this.linkSets.get(linksetId);
    }

    protected void manageLinkSet() {
        for (LinkSet linkSet : this.linkSets) {
            if (linkSet.getActiveLinks().size() == linkSet.getLinks().size()) continue;
            linkSet.activateLink();
            break;
        }
    }

    public void linkInService(Mtp2 mtp2) {
        this.resetForInservice(mtp2);
        this.sendTRA(mtp2);
        this.sendSLTM(mtp2);
        this.manageLinkSet();
    }

    public void linkFailed(Mtp2 mtp2) {
        this.resetForInservice(mtp2);
        boolean hasUplinks = false;
        for (LinkSet linkSet : this.linkSets) {
            if (linkSet.getActiveLinks().size() <= 0) continue;
            hasUplinks = true;
            break;
        }
        if (!hasUplinks) {
            this.l4IsUp = false;
            if (this.layer4 != null) {
                this.layer4.linkDown();
            }
        }
        this.manageLinkSet();
    }

    private void resetForInservice(Mtp2 mtp2) {
        mtp2.stop_T1_SLTM();
        mtp2.stop_T2_SLTM();
        mtp2.restartSltmTries();
    }

    private void sendTRA(Mtp2 mtp2) {
        int subservice = mtp2.getSubService();
        subservice = 12;
        byte[] buffer = new byte[6];
        this.writeRoutingLabel(buffer, mtp2);
        buffer[0] = -64;
        buffer[5] = 23;
        if (this.logger.isDebugEnabled() && this.isL3Debug()) {
            mtp2.trace("Queue TRA");
        }
        mtp2.queue(buffer);
    }

    private void sendSLTM(Mtp2 mtp2) {
        byte[] sltm = new byte[7 + SLTM_PATTERN.length];
        sltm[0] = -63;
        this.writeRoutingLabel(sltm, mtp2);
        sltm[5] = 17;
        sltm[6] = (byte)(SLTM_PATTERN.length << 4);
        System.arraycopy(SLTM_PATTERN, 0, sltm, 7, SLTM_PATTERN.length);
        if (this.logger.isDebugEnabled() && this.isL3Debug()) {
            mtp2.trace("Queue SLTM");
        }
        mtp2.queue(sltm);
        mtp2.incrementSltmTries();
        if (!mtp2.isT1_SLTM()) {
            mtp2.start_T1_SLTM();
        }
        mtp2.start_T2_SLTM();
    }

    private void writeRoutingLabel(byte[] sif, Mtp2 mtp2) {
        LinkSet ls = mtp2.getLinkSet();
        int destinationPointCode = ls.getDpc();
        int originationPointCode = ls.getOpc();
        sif[1] = (byte)destinationPointCode;
        sif[2] = (byte)(destinationPointCode >> 8 & 0x3F | (originationPointCode & 3) << 6);
        sif[3] = (byte)(originationPointCode >> 2);
        sif[4] = (byte)(originationPointCode >> 10 & 0xF | 0);
    }

    private boolean checkPattern(byte[] sif, byte[] pattern) {
        if (sif.length - 6 != pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (sif[i + 6] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    private void performSLTARetryProcedure(Mtp2 mtp2) {
        if (mtp2.getSltmTries() == 1) {
            if (this.logger.isEnabledFor((Priority)Level.ERROR) && this.isL3Debug()) {
                mtp2.trace("No valid SLTA received within Q.707_T1, trying again.");
            }
            this.sendSLTM(mtp2);
        } else {
            if (this.logger.isEnabledFor((Priority)Level.ERROR) && this.isL3Debug()) {
                mtp2.trace("No valid SLTA received within Q.707_T1, faulting link.....");
            }
            mtp2.restartSltmTries();
            mtp2.failLink();
            mtp2.start_T17();
        }
    }

    private static final int _getFromSif_DPC(byte[] sif, int shift) {
        int dpc = sif[0 + shift] & 0xFF | (sif[1 + shift] & 0x3F) << 8;
        return dpc;
    }

    private static final int _getFromSif_OPC(byte[] sif, int shift) {
        int opc = (sif[1 + shift] & 0xC0) >> 6 | (sif[2 + shift] & 0xFF) << 2 | (sif[3 + shift] & 0xF) << 10;
        return opc;
    }

    private static final int _getFromSif_SLS(byte[] sif, int shift) {
        int sls = (sif[3 + shift] & 0xF0) >>> 4;
        return sls;
    }

    public boolean isL3Debug() {
        return this.l3Debug;
    }

    public void setL3Debug(boolean l3Debug) {
        this.l3Debug = l3Debug;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LinkSetComparator
    implements Comparator<LinkSet> {
        private LinkSetComparator() {
        }

        @Override
        public int compare(LinkSet o1, LinkSet o2) {
            if (o2 == null) {
                return 1;
            }
            if (o1 == null) {
                return -1;
            }
            return o1.getId() - o2.getId();
        }
    }

    private final class ProcessorClass
    implements Runnable {
        private Mtp2 mtp2;
        private int sio;
        private byte[] sif;

        private ProcessorClass() {
        }

        public void run() {
            int subserviceIndicator = this.sio >> 4 & 3;
            int serviceIndicator = this.sio & 0xF;
            int dpc = Mtp3Impl._getFromSif_DPC(this.sif, 0);
            int opc = Mtp3Impl._getFromSif_OPC(this.sif, 0);
            int sls = Mtp3Impl._getFromSif_SLS(this.sif, 0);
            if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                this.mtp2.trace("Received MSSU [si=" + serviceIndicator + ",ssi=" + subserviceIndicator + ", dpc=" + dpc + ", opc=" + opc + ", sls=" + sls + "]");
            }
            switch (serviceIndicator) {
                case 0: {
                    break;
                }
                case 1: {
                    int h0 = this.sif[4] & 0xF;
                    int h1 = (this.sif[4] & 0xF0) >>> 4;
                    int len = (this.sif[5] & 0xF0) >>> 4;
                    if (h0 == 1 && h1 == 1) {
                        if (Mtp3Impl.this.logger.isDebugEnabled() && Mtp3Impl.this.isL3Debug()) {
                            this.mtp2.trace("Received SLTM");
                        }
                        byte[] slta = new byte[len + 7];
                        slta[0] = (byte)this.sio;
                        Mtp3Impl.this.writeRoutingLabel(slta, this.mtp2);
                        slta[5] = 33;
                        System.arraycopy(this.sif, 5, slta, 6, len + 1);
                        if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                            if (Mtp3Impl.this.logger.isDebugEnabled()) {
                                int remote_OPC = opc;
                                int remote_DPC = dpc;
                                int remote_SLS = sls;
                                int slta_OPC = Mtp3Impl._getFromSif_OPC(slta, 1);
                                int slta_DPC = Mtp3Impl._getFromSif_DPC(slta, 1);
                                int slta_SLS = Mtp3Impl._getFromSif_SLS(slta, 1);
                                if (remote_OPC != slta_DPC || remote_DPC != slta_OPC || remote_SLS != slta_SLS) {
                                    this.mtp2.trace("Failed check on sending SLTA, values do not match, remote SLTM/SLTA check will fail\nremote OPC = " + remote_OPC + ", SLTA DPC = " + slta_DPC + ", remote DPC = " + remote_DPC + ", SLTA OPC = " + slta_OPC + ", remote SLS = " + remote_SLS + ", SLTA SLS = " + slta_SLS);
                                }
                            }
                            if (Mtp3Impl.this.logger.isDebugEnabled() && Mtp3Impl.this.isL3Debug()) {
                                this.mtp2.trace("Responding with SLTA");
                            }
                        }
                        this.mtp2.queue(slta);
                        break;
                    }
                    if (h0 == 1 && h1 == 2) {
                        if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                            this.mtp2.trace("Received SLTA");
                        }
                        this.mtp2.stop_T1_SLTM();
                        StringBuilder sb = new StringBuilder();
                        boolean accepted = true;
                        if (opc != this.mtp2.getLinkSet().getDpc()) {
                            if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                                sb.append("\nSLTA Acceptance failed, OPC = ").append(opc).append(" ,of SLTA does not match local DPC = ").append(this.mtp2.getLinkSet().getDpc());
                            }
                            accepted = false;
                        }
                        if (dpc != this.mtp2.getLinkSet().getOpc()) {
                            if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                                sb.append("\nSLTA Acceptance failed, DPC = ").append(dpc).append(" ,of SLTA does not match local OPC = ").append(this.mtp2.getLinkSet().getOpc());
                            }
                            accepted = false;
                        }
                        if (!Mtp3Impl.this.checkPattern(this.sif, SLTM_PATTERN)) {
                            if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                                sb.append("\nSLTA Acceptance failed, sif pattern = ").append(Arrays.toString(this.sif)).append(" ,of SLTA does not match local pattern = ").append(Arrays.toString(SLTM_PATTERN));
                            }
                            accepted = false;
                        }
                        if (sls != this.mtp2.getSls()) {
                            if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                                sb.append("\nSLTA Acceptance failed, sls  = ").append(sls).append(" ,of SLTA does not match local sls = ").append(this.mtp2.getSls());
                            }
                            accepted = false;
                        }
                        if (accepted) {
                            this.mtp2.restartSltmTries();
                            if (Mtp3Impl.this.l4IsUp || Mtp3Impl.this.layer4 == null) break;
                            if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                                this.mtp2.trace("XXX Notify layer 4 on success SLTM handshake");
                            }
                            Mtp3Impl.this.l4IsUp = true;
                            Mtp3Impl.this.layer4.linkUp();
                            break;
                        }
                        if (Mtp3Impl.this.logger.isTraceEnabled() && Mtp3Impl.this.isL3Debug()) {
                            this.mtp2.trace("SLTA acceptance failed!!! Reason: " + sb);
                        }
                        Mtp3Impl.this.performSLTARetryProcedure(this.mtp2);
                        break;
                    }
                    if (!Mtp3Impl.this.logger.isEnabledFor((Priority)Level.WARN) || !Mtp3Impl.this.isL3Debug()) break;
                    this.mtp2.trace("XXX Unexpected message type");
                    break;
                }
                case 3: {
                    if (Mtp3Impl.this.logger.isEnabledFor((Priority)Level.WARN) && Mtp3Impl.this.isL3Debug()) {
                        this.mtp2.trace("XXX MSU Indicates SCCP");
                    }
                    if (Mtp3Impl.this.layer4 == null) break;
                    byte[] msgBuff = new byte[this.sif.length - 4];
                    System.arraycopy(this.sif, 4, msgBuff, 0, msgBuff.length);
                    Mtp3Impl.this.layer4.receive(this.mtp2.getSls(), this.mtp2.getLinkSet().getId(), 3, subserviceIndicator, msgBuff);
                    break;
                }
                case 5: {
                    if (Mtp3Impl.this.logger.isEnabledFor((Priority)Level.WARN) && Mtp3Impl.this.isL3Debug()) {
                        this.mtp2.trace("XXX MSU Indicates ISUP");
                    }
                    if (Mtp3Impl.this.layer4 == null) break;
                    byte[] msgBuff = new byte[this.sif.length - 4];
                    System.arraycopy(this.sif, 4, msgBuff, 0, msgBuff.length);
                    Mtp3Impl.this.layer4.receive(this.mtp2.getSls(), this.mtp2.getLinkSet().getId(), 5, subserviceIndicator, msgBuff);
                    break;
                }
                default: {
                    if (!Mtp3Impl.this.logger.isEnabledFor((Priority)Level.WARN) || !Mtp3Impl.this.isL3Debug()) break;
                    this.mtp2.trace("XXX MSU Indicates UNKNOWN SERVICE!!!!!!!!!!!: " + Utils.dump((byte[])this.sif, (int)this.sif.length, (boolean)false));
                }
            }
        }

        static /* synthetic */ byte[] access$702(ProcessorClass x0, byte[] x1) {
            x0.sif = x1;
            return x1;
        }
    }

    private class T2Action_SLTM
    implements Runnable {
        private Mtp2 mtp2;

        private T2Action_SLTM() {
        }

        public void run() {
            Mtp3Impl.this.sendSLTM(this.mtp2);
        }
    }

    private class T1Action_SLTM
    implements Runnable {
        private Mtp2 mtp2;

        private T1Action_SLTM() {
        }

        public void run() {
            Mtp3Impl.this.performSLTARetryProcedure(this.mtp2);
        }
    }
}

