/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.ss7.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.resource.ss7.stream.HDLCHandler;
import org.mobicents.media.server.spi.resource.ss7.Mtp3;
import org.mobicents.media.server.spi.resource.ss7.SS7Layer4;
import org.mobicents.media.server.spi.resource.ss7.stream.StreamForwarder;

public class SimpleTCPForwarder
implements SS7Layer4,
StreamForwarder,
Runnable {
    private static final Logger logger = Logger.getLogger(SimpleTCPForwarder.class);
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private int port = 1354;
    private InetAddress address;
    private ServerSocketChannel serverSocketChannel;
    private SocketChannel channel;
    private Selector readSelector;
    private Selector writeSelector;
    private Selector connectSelector;
    private boolean connected = false;
    private ByteBuffer readBuff = ByteBuffer.allocate(8192);
    private ByteBuffer txBuff = ByteBuffer.allocate(8192);
    private Mtp3 layer3;
    private boolean linkUp = false;
    private Future runFuture;
    private int si;
    private int ssf;
    private HDLCHandler hdlcHandler = new HDLCHandler();

    public SimpleTCPForwarder() {
        this.txBuff.position(this.txBuff.capacity());
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Iterator<SelectionKey> selectedKeys = null;
                    if (!this.connected) {
                        this.connectSelector.select();
                        selectedKeys = this.connectSelector.selectedKeys().iterator();
                        this.performKeyOperations(selectedKeys);
                        continue;
                    }
                    if (!this.linkUp) continue;
                    if (this.readSelector.selectNow() > 0) {
                        selectedKeys = this.readSelector.selectedKeys().iterator();
                        this.performKeyOperations(selectedKeys);
                    }
                    if (this.writeSelector.selectNow() > 0) {
                        selectedKeys = this.writeSelector.selectedKeys().iterator();
                        this.performKeyOperations(selectedKeys);
                    }
                    if (!this.hdlcHandler.isTxBufferEmpty()) continue;
                    Thread.currentThread();
                    Thread.sleep(4L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void performKeyOperations(Iterator selectedKeys) throws IOException {
        while (selectedKeys.hasNext()) {
            SelectionKey key = (SelectionKey)selectedKeys.next();
            selectedKeys.remove();
            if (!key.isValid()) continue;
            if (key.isAcceptable()) {
                this.accept(key);
                continue;
            }
            if (key.isReadable()) {
                this.read(key);
                continue;
            }
            if (!key.isWritable()) continue;
            this.write(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte sls, byte linksetId, byte[] data) {
        if (!this.connected) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"There is no client interested in data stream, ignoring. Message should be retransmited.");
            }
            return;
        }
        HDLCHandler hDLCHandler = this.hdlcHandler;
        synchronized (hDLCHandler) {
            ByteBuffer bb = ByteBuffer.allocate(2 + data.length);
            bb.put(sls);
            bb.put(linksetId);
            bb.put(data);
            this.hdlcHandler.addToTxBuffer(bb);
        }
        this.writeSelector.wakeup();
    }

    private void read(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        this.readBuff.clear();
        int numRead = -1;
        try {
            numRead = socketChannel.read(this.readBuff);
        }
        catch (IOException e) {
            this.handleClose(key);
            return;
        }
        if (numRead == -1) {
            this.handleClose(key);
            return;
        }
        ByteBuffer[] readResult = null;
        this.readBuff.flip();
        while ((readResult = this.hdlcHandler.processRx(this.readBuff)) != null) {
            for (ByteBuffer b : readResult) {
                byte sls = b.get();
                byte linksetId = b.get();
                this.layer3.send(sls, linksetId, this.si, this.ssf, b.array());
            }
        }
        this.readBuff.clear();
    }

    private void accept(SelectionKey key) throws IOException {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        if (this.connected) {
            serverSocketChannel.close();
            return;
        }
        this.channel = serverSocketChannel.accept();
        Socket socket = this.channel.socket();
        this.channel.configureBlocking(false);
        this.channel.register(this.readSelector, 1);
        this.channel.register(this.writeSelector, 4);
        this.connected = true;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Estabilished connection with: " + socket.getInetAddress() + ":" + socket.getPort()));
        }
    }

    private void write(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        if (this.txBuff.remaining() > 0) {
            socketChannel.write(this.txBuff);
            if (this.txBuff.remaining() > 0) {
                return;
            }
        }
        if (!this.hdlcHandler.isTxBufferEmpty()) {
            this.txBuff.clear();
            this.hdlcHandler.processTx(this.txBuff);
            this.txBuff.flip();
            socketChannel.write(this.txBuff);
            if (this.txBuff.remaining() > 0) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClose(SelectionKey key) throws IOException {
        try {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            key.cancel();
            socketChannel.close();
        }
        finally {
            this.connected = false;
            HDLCHandler hDLCHandler = this.hdlcHandler;
            synchronized (hDLCHandler) {
                this.hdlcHandler.clearTxBuffer();
            }
        }
    }

    public void linkDown() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Received L4 Down event from layer3.");
        }
        this.linkUp = false;
    }

    public void linkUp() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Received L4 Up event from layer3.");
        }
        this.linkUp = true;
    }

    public void receive(byte sls, byte linksetId, int service, int subservice, byte[] msgBuff) {
        if (this.linkUp) {
            this.send(sls, linksetId, msgBuff);
        }
    }

    public String getAddress() {
        return this.address.toString();
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(String address) throws UnknownHostException {
        this.address = InetAddress.getAllByName(address)[0];
    }

    public void setPort(int port) {
        if (port > 0) {
            this.port = port;
        }
    }

    public void start() throws Exception {
        this.initServer();
        this.runFuture = this.executor.submit(this);
    }

    public void stop() {
        if (this.runFuture == null) {
            return;
        }
        this.runFuture.cancel(false);
        this.runFuture = null;
    }

    private void initServer() throws Exception {
        this.readSelector = SelectorProvider.provider().openSelector();
        this.writeSelector = SelectorProvider.provider().openSelector();
        this.connectSelector = SelectorProvider.provider().openSelector();
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(this.address, this.port);
        this.serverSocketChannel.socket().bind(isa);
        this.serverSocketChannel.register(this.connectSelector, 16);
        logger.info((Object)("Initiaited server on: " + this.address + ":" + this.port));
    }

    public void setLayer3(Mtp3 layer3) {
        this.layer3 = layer3;
        if (layer3 != null) {
            this.layer3.setLayer4((SS7Layer4)this);
        }
    }

    public void setServiceIndicator(int i) {
        this.si = i;
    }

    public void setSubServiceIndicator(int i) {
        this.ssf = i;
    }
}

