/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.test;

import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.dsp.Codec;

public class MeanderGenerator
extends AbstractSource {
    private static final Format[] FORMATS = new Format[]{Codec.LINEAR_AUDIO};
    private double time;
    private double dt;
    private int pSize;
    private double T;
    private short A;

    public MeanderGenerator(String name, SyncSource syncSource) {
        super(name);
        this.setSyncSource(syncSource);
        this.dt = 1.0 / Codec.LINEAR_AUDIO.getSampleRate();
    }

    public void setPeriod(double T) {
        this.T = T / 2.0;
    }

    public void setAmplitude(short A) {
        this.A = A;
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    private short getValue(double t) {
        return (long)Math.floor(t / this.T) % 2L == 0L ? this.A : (short)0;
    }

    public void evolve(Buffer buffer, long timestamp) {
        int k = 0;
        this.pSize = (int)(0.02 / this.dt);
        byte[] data = new byte[2 * this.pSize];
        for (int i = 0; i < this.pSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        buffer.setData(data);
        buffer.setOffset(0);
        buffer.setLength(data.length);
        buffer.setDuration(20L);
        buffer.setFormat((Format)Codec.LINEAR_AUDIO);
        buffer.setTimeStamp(this.getMediaTime());
        buffer.setDiscard(false);
        buffer.setFlags(32768);
        this.time += 0.02;
    }
}

