/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.test;

import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Timer;

public class SineGenerator
extends AbstractSource {
    private static final AudioFormat LINEAR_AUDIO = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private static final Format[] FORMAT = new Format[]{LINEAR_AUDIO};
    private int f;
    private short A = Short.MAX_VALUE;
    private double dt;
    private int pSize;
    private double time;

    public SineGenerator(String name, Timer timer) {
        super(name);
        this.setSyncSource((SyncSource)timer);
        this.init();
    }

    public SineGenerator(Endpoint endpoint, String name) {
        super(name);
        this.setSyncSource((SyncSource)endpoint.getTimer());
        this.init();
    }

    private void init() {
        this.dt = 1.0 / LINEAR_AUDIO.getSampleRate();
    }

    public void setAmplitude(short A) {
        this.A = A;
    }

    public short getAmplitude() {
        return this.A;
    }

    public void setFrequency(int f) {
        this.f = f;
    }

    public int getFrequency() {
        return this.f;
    }

    private short getValue(double t) {
        return (short)((double)this.A * Math.sin(Math.PI * 2 * (double)this.f * t));
    }

    public void evolve(Buffer buffer, long timestamp) {
        int k = 0;
        int frameSize = (int)(0.02 / this.dt);
        byte[] data = new byte[2 * frameSize];
        for (int i = 0; i < frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        buffer.setData(data);
        buffer.setOffset(0);
        buffer.setLength(data.length);
        buffer.setDuration(20L);
        buffer.setTimeStamp(this.getSyncSource().getTimestamp());
        this.time += 0.02;
    }

    public Format[] getFormats() {
        return FORMAT;
    }
}

