/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.test;

import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.resource.test.MeanderDetector;
import org.mobicents.media.server.impl.resource.test.MeanderGenerator;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Timer;
import org.mobicents.media.server.spi.events.NotifyEvent;

public class TransmissionTester
implements NotificationListener {
    private static final int TEST_DURATION = 10;
    public static final short A = 100;
    public static final double T = 0.1;
    private MeanderGenerator gen;
    private MeanderDetector det;
    private MediaSink sink;
    private MediaSource source;
    private int outOfSeq;
    private int evtCount;
    private boolean fmtMissmatch = false;
    private boolean isPassed = false;
    private String msg = "Not started yet";

    public TransmissionTester(Timer timer) {
        this.gen = new MeanderGenerator("Tester[generator]", (SyncSource)timer);
        this.gen.setAmplitude((short)100);
        this.gen.setPeriod(0.1);
        this.det = new MeanderDetector("Tester[detector]");
        this.det.setAmplitude((short)100);
        this.det.setPeriod(0.1);
        this.det.addListener(this);
    }

    public MeanderGenerator getGenerator() {
        return this.gen;
    }

    public MeanderDetector getDetector() {
        return this.det;
    }

    public void connect(MediaSink sink) {
        this.sink = sink;
        this.gen.connect(sink);
    }

    public void connect(MediaSource source) {
        this.source = source;
        this.det.connect(source);
    }

    public void start() {
        this.evtCount = 0;
        this.isPassed = false;
        this.det.start();
        this.gen.start();
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            this.msg = "Test interrupted";
            return;
        }
        this.gen.stop();
        this.det.stop();
        if (this.sink != null) {
            this.gen.disconnect(this.sink);
        }
        if (this.source != null) {
            this.det.disconnect(this.source);
        }
        int count = 50;
        int limit = 6;
        int diff = Math.abs(count - this.evtCount);
        if (diff > limit) {
            this.isPassed = false;
            this.msg = "Signal not detected or damaged, errors=" + diff;
            return;
        }
        if (this.outOfSeq > 0) {
            this.isPassed = false;
            this.msg = "There are out of sequence packets: " + this.outOfSeq;
            return;
        }
        if (this.fmtMissmatch) {
            this.isPassed = false;
            this.msg = "Format missmatch detected: ";
            return;
        }
        this.isPassed = true;
        this.msg = "";
    }

    public boolean isPassed() {
        return this.isPassed;
    }

    public String getMessage() {
        return this.msg;
    }

    public void update(NotifyEvent event) {
        if (event.getEventID() == 0) {
            ++this.evtCount;
        } else if (event.getEventID() == 1) {
            ++this.outOfSeq;
        } else if (event.getEventID() == 2) {
            this.fmtMissmatch = true;
        }
    }
}

