/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.test;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.resource.fft.SpectraAnalyzer;
import org.mobicents.media.server.impl.resource.fft.SpectrumEvent;
import org.mobicents.media.server.impl.resource.test.SineGenerator;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.clock.Timer;
import org.mobicents.media.server.spi.events.FailureEvent;
import org.mobicents.media.server.spi.events.NotifyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransmissionTester2
implements NotificationListener {
    private static final int TEST_DURATION = 10;
    private int MAX_ERRORS = 1;
    private static final int FREQ_ERROR = 5;
    private static final short A = 1000;
    private static final int f = 150;
    private SineGenerator gen;
    private SpectraAnalyzer det;
    private MediaSink sink;
    private MediaSource source;
    private ArrayList<double[]> s = new ArrayList();
    private boolean isPassed = false;
    private String msg = "Not started yet";
    private Semaphore semaphore = new Semaphore(0);

    public TransmissionTester2(Timer timer) {
        this.gen = new SineGenerator("sine.generator", timer);
        this.gen.setAmplitude((short)1000);
        this.gen.setFrequency(150);
        this.det = new SpectraAnalyzer("spectra.analyzer");
        this.det.addListener(this);
        this.gen.addListener(this);
    }

    public SineGenerator getGenerator() {
        return this.gen;
    }

    public SpectraAnalyzer getDetector() {
        return this.det;
    }

    public void connect(MediaSink sink) {
        this.sink = sink;
        this.gen.connect(sink);
    }

    public void connect(MediaSource source) {
        this.source = source;
        this.det.connect(source);
    }

    public void start() {
        this.s.clear();
        this.det.start();
        this.gen.start();
        this.isPassed = true;
        try {
            this.semaphore.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.msg = "Test interrupted";
            return;
        }
        this.gen.stop();
        this.det.stop();
        if (this.sink != null) {
            this.gen.disconnect(this.sink);
        }
        if (this.source != null) {
            this.det.disconnect(this.source);
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isPassed) {
            return;
        }
        this.isPassed = this.verify(this.s, new int[]{150});
    }

    private boolean verify(ArrayList<double[]> spectra, int[] F) {
        int errorCount = 0;
        if (spectra.size() == 0) {
            this.msg = "Data not received";
            return false;
        }
        for (double[] ss : spectra) {
            int[] ext = this.getFreq(ss);
            if (ext.length == 0) {
                this.msg = "Received silence [" + spectra.size() + " seconds]";
                return false;
            }
            boolean r = this.checkFreq(ext, F, 5);
            if (r) continue;
            ++errorCount;
        }
        return errorCount <= this.MAX_ERRORS;
    }

    public boolean checkFreq(int[] ext, int[] F, int error) {
        for (int i = 0; i < F.length; ++i) {
            if (Math.abs(ext[i] - F[i]) <= error) continue;
            this.msg = "Expected " + F[i] + " but found " + ext[i];
            return false;
        }
        return true;
    }

    public int[] getFreq(double[] s) {
        double max = this.findMax(s);
        int len = s.length / 2;
        double[] ss = new double[len];
        for (int i = 0; i < len; ++i) {
            ss[i] = s[i] / max;
            ss[i] = ss[i] < 0.7 ? 0.0 : ss[i];
        }
        double[] diff = this.diff(ss);
        int[] ext = this.findExtremums(diff);
        return ext;
    }

    private double[] diff(double[] f) {
        double[] diff = new double[f.length];
        for (int i = 0; i < f.length - 1; ++i) {
            diff[i] = f[i + 1] - f[i];
        }
        return diff;
    }

    private double findMax(double[] f) {
        double max = f[0];
        for (int i = 1; i < f.length; ++i) {
            max = Math.max(max, f[i]);
        }
        return max;
    }

    private int[] findExtremums(double[] f) {
        ArrayList<Integer> ext = new ArrayList<Integer>();
        for (int i = 0; i < f.length - 1; ++i) {
            if (!(f[i] > 0.0) || !(f[i + 1] < 0.0)) continue;
            ext.add(i);
        }
        int[] res = new int[ext.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Integer)ext.get(i);
        }
        return res;
    }

    public boolean isPassed() {
        return this.isPassed;
    }

    public String getMessage() {
        return this.msg;
    }

    public void update(NotifyEvent event) {
        if (event.getEventID() == 40) {
            SpectrumEvent evt = (SpectrumEvent)event;
            this.s.add(evt.getSpectra());
        } else if (event.getEventID() == 10002) {
            this.isPassed = false;
            this.msg = "Transmission error: " + ((FailureEvent)event).getSource();
            ((FailureEvent)event).getException().printStackTrace();
            this.semaphore.release();
        }
    }
}

