/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.zap;

import java.io.File;
import java.util.Map;
import org.mobicents.protocols.ss7.mtp.Mtp1;
import org.mobicents.protocols.ss7.mtp.Mtp2;

public class Channel
implements Mtp1 {
    private static final String MMS_HOME = "MMS_HOME";
    private static final String LIB_NAME = "zap-native-linux.so";
    private int span;
    private int channelID;
    private int code;
    private String linkName;
    protected int fd;
    private Mtp2 link;

    public void setLink(Mtp2 link) {
        this.link = link;
    }

    public Mtp2 getLink() {
        return this.link;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public int getChannelID() {
        return this.channelID;
    }

    public void setChannelID(int channelID) {
        this.channelID = channelID;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void open() {
        int zapid = 31 * (this.span - 1) + this.channelID;
        this.fd = this.openChannel(zapid);
    }

    public native int openChannel(int var1);

    public int read(byte[] buffer) {
        return this.readData(this.fd, buffer);
    }

    public native int readData(int var1, byte[] var2);

    public void write(byte[] buffer, int len) {
        this.writeData(this.fd, buffer, len);
    }

    public native void writeData(int var1, byte[] var2, int var3);

    public void close() {
        this.closeChannel(this.fd);
    }

    public native void closeChannel(int var1);

    public String toString() {
        return Integer.toString(this.channelID);
    }

    static {
        try {
            Map<String, String> env = System.getenv();
            if (env.get(MMS_HOME) != null) {
                String path = env.get(MMS_HOME) + File.separator + "native" + File.separator + LIB_NAME;
                System.load(path);
                System.out.println("Loaded library " + path);
            } else {
                System.out.println("Can not load library");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

