/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.zap;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.resource.zap.Channel;
import org.mobicents.protocols.ss7.mtp.ChannelSelector;
import org.mobicents.protocols.ss7.mtp.Mtp1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector
implements ChannelSelector {
    private static final String MMS_HOME = "MMS_HOME";
    private static final String LIB_NAME = "zap-native-linux.so";
    public static final int READ = 1;
    public static final int WRITE = 2;
    private int[] fds = new int[16];
    private ArrayList<Mtp1> registered = new ArrayList();
    private ArrayList<Mtp1> selected = new ArrayList();
    private static Logger logger = Logger.getLogger(ChannelSelector.class);

    public void register(Mtp1 channel) {
        this.registered.add(channel);
        logger.info((Object)("Registering file descriptor:" + ((Channel)channel).fd));
        this.doRegister(((Channel)channel).fd);
    }

    public void unregister(Mtp1 channel) {
        this.registered.remove(channel);
        this.doUnregister(((Channel)channel).fd);
    }

    public Collection<Mtp1> select(int key, int timeout) {
        int count = this.doPoll(this.fds, key, timeout);
        this.selected.clear();
        for (int i = 0; i < count; ++i) {
            for (Mtp1 chan : this.registered) {
                Channel channel = (Channel)chan;
                if (channel.fd != this.fds[i]) continue;
                this.selected.add(chan);
            }
        }
        return this.selected;
    }

    public native void doRegister(int var1);

    public native void doUnregister(int var1);

    public native int doPoll(int[] var1, int var2, int var3);

    static {
        try {
            Map<String, String> env = System.getenv();
            if (env.get(MMS_HOME) != null) {
                String path = env.get(MMS_HOME) + File.separator + "native" + File.separator + LIB_NAME;
                System.load(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

