/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;

public class JitterBuffer
implements Serializable {
    static final int _QUEUE_SIZE_ = 100;
    private int jitter;
    private boolean readStarted = true;
    private boolean writeStarted = false;
    private RtpPacket[] queue = new RtpPacket[100];
    private int readCursor;
    private int writeCursor;
    private volatile boolean ready = false;
    private long duration;
    private long timestamp;
    private Format format;
    private RtpClock clock;
    private static Logger logger = Logger.getLogger(JitterBuffer.class);
    private long drift;
    private long r;
    private long s;
    private double j;
    private double jm;

    public JitterBuffer(int jitter) {
        this.jitter = jitter;
    }

    public void setClock(RtpClock clock) {
        this.clock = clock;
        if (this.format != null) {
            clock.setFormat(this.format);
        }
    }

    public void setFormat(Format format) {
        this.format = format;
        if (this.clock != null && format != Format.ANY) {
            this.clock.setFormat(format);
        }
    }

    public int getJitter() {
        return this.jitter;
    }

    public double getInterArrivalJitter() {
        return this.j;
    }

    public double getMaxJitter() {
        return this.jm;
    }

    public void write(RtpPacket packet) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Receive " + packet));
        }
        long now = System.currentTimeMillis();
        long t = this.clock.getTime(packet.getTimestamp());
        packet.setTime(t);
        if (this.r > 0L && this.s > 0L) {
            long D = now - this.r - (packet.getTime() - this.s);
            if (D < 0L) {
                D = -D;
            }
            this.j += ((double)D - this.j) / 16.0;
            if (this.jm < this.j) {
                this.jm = this.j;
            }
        }
        this.s = packet.getTime();
        this.r = now;
        if (this.ready && this.readStarted && t <= this.timestamp) {
            logger.warn((Object)("Packet " + packet + " is discarded by jitter buffer( packet time=" + t + ", current time " + this.timestamp));
            return;
        }
        if (!this.writeStarted) {
            this.queue[0] = packet;
            this.writeStarted = true;
        } else {
            RtpPacket prev = this.queue[this.writeCursor];
            long diff = packet.getSeqNumber() - prev.getSeqNumber();
            if (diff == 1L) {
                this.writeCursor = this.inc(this.writeCursor, 1);
                this.checkSimpleOverflow(this.writeCursor);
                this.queue[this.writeCursor] = packet;
                prev.setDuration(packet.getTime() - prev.getTime());
                this.duration += prev.getDuration();
            } else if (diff > 1L) {
                prev.setDuration(packet.getTime() - prev.getTime());
                int nextWriteCursor = this.inc(this.writeCursor, (int)diff);
                this.checkPositiveOverflow(nextWriteCursor, diff);
                this.writeCursor = nextWriteCursor;
                this.queue[this.writeCursor] = packet;
                this.duration += prev.getDuration();
            } else {
                int rightIndex = this.writeCursor;
                this.writeCursor = this.inc(this.writeCursor, (int)diff);
                this.queue[this.writeCursor] = packet;
                int i = this.dec(this.writeCursor, 1);
                for (int count = 0; this.queue[i] == null && count < this.queue.length - 1; ++count) {
                    i = this.dec(i, 1);
                }
                this.queue[i].setDuration(packet.getTime() - this.queue[i].getTime());
                i = this.inc(this.writeCursor, 1);
                while (this.queue[i] == null && i < rightIndex) {
                    i = this.inc(i, 1);
                }
                packet.setDuration(this.queue[i].getTime() - packet.getTime());
            }
        }
        if (!this.ready && this.duration > (long)this.jitter) {
            this.ready = true;
        }
    }

    private void checkSimpleOverflow(int toBeWrittenCurson) {
        if (this.readCursor == toBeWrittenCurson) {
            RtpPacket removed = this.queue[this.readCursor];
            this.queue[this.readCursor] = null;
            this.readCursor = this.inc(this.readCursor, 1);
            this.duration -= removed.getDuration();
        }
    }

    private void checkPositiveOverflow(int nextWriteCursor, long diff) {
        long boundry = (long)this.writeCursor + diff;
        if (boundry >= 100L) {
            if (this.readCursor > this.writeCursor && nextWriteCursor < this.readCursor) {
                this.cleanBufferOnPositiveOverflow(nextWriteCursor);
            } else if (this.readCursor < this.writeCursor && nextWriteCursor >= this.readCursor) {
                this.cleanBufferOnPositiveOverflow(nextWriteCursor);
            }
        } else if (this.readCursor > this.writeCursor && nextWriteCursor >= this.readCursor) {
            this.cleanBufferOnPositiveOverflow(nextWriteCursor);
        }
    }

    private void cleanBufferOnPositiveOverflow(int nextWriteCursor) {
        int oldRead = this.readCursor;
        this.readCursor = this.inc(nextWriteCursor, 1);
        while (nextWriteCursor != oldRead - 1) {
            if (this.queue[nextWriteCursor] == null) {
                return;
            }
            RtpPacket removed = this.queue[nextWriteCursor];
            this.queue[nextWriteCursor] = null;
            this.duration -= removed.getDuration();
            nextWriteCursor = this.dec(nextWriteCursor, 1);
        }
    }

    private int inc(int a, int diff) {
        int res = a + diff;
        if (res >= this.queue.length) {
            res -= this.queue.length;
        }
        return res;
    }

    private int dec(int a, int diff) {
        int res = a - diff;
        if (res < 0) {
            res = this.queue.length + res;
        }
        return res;
    }

    public void reset() {
        this.duration = 0L;
        this.clock.reset();
        this.drift = 0L;
        this.r = 0L;
        this.s = 0L;
        this.ready = false;
        this.readStarted = true;
        this.writeStarted = false;
        this.readCursor = 0;
        this.writeCursor = 0;
    }

    public RtpPacket read(long timestamp) {
        if (!this.ready) {
            return null;
        }
        if (!this.readStarted) {
            this.readStarted = true;
            this.drift = this.queue[0].getTime() - timestamp;
        }
        this.timestamp = timestamp + this.drift;
        if (this.duration == 0L) {
            return null;
        }
        RtpPacket packet = this.queue[this.readCursor];
        this.queue[this.readCursor] = null;
        this.duration -= packet.getDuration();
        this.readCursor = this.inc(this.readCursor, 1);
        while (this.duration >= 0L && this.queue[this.readCursor] == null) {
            this.readCursor = this.inc(this.readCursor, 1);
        }
        return packet;
    }
}

