/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.util.ArrayList;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.rtp.JitterBuffer;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.RtpSocket;
import org.mobicents.media.server.impl.rtp.rfc2833.DtmfConverter;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.dsp.Codec;

public class ReceiveStream
extends AbstractSource {
    private RtpSocket rtpSocket;
    private JitterBuffer jitterBuffer;
    protected int mainstream;
    private int dtmf;
    private ArrayList<Format> formats = new ArrayList();
    private AVProfile avProfile;
    private Codec codec;
    private int jitter;
    private DtmfConverter dtmfConverter = new DtmfConverter();
    protected long byteCount;

    public ReceiveStream(RtpSocket rtpSocket, int jitter, AVProfile formatConfig) {
        super("ReceiveStream");
        this.jitter = jitter;
        this.avProfile = formatConfig;
        this.rtpSocket = rtpSocket;
        this.setSyncSource((SyncSource)rtpSocket.timer);
        this.jitterBuffer = new JitterBuffer(jitter);
        this.jitterBuffer.setClock(rtpSocket.getClock());
        this.dtmfConverter.setClock(rtpSocket.getClock());
    }

    protected void process(RtpPacket rtpPacket) {
        this.jitterBuffer.write(rtpPacket);
    }

    public void beforeStart() {
        this.jitterBuffer.reset();
    }

    public void connect(MediaSink sink) {
        if (this.rtpSocket.getFormat() == null) {
            throw new IllegalStateException("RTP has no negotiated formats");
        }
        super.connect(sink);
    }

    public void setDtmf(int dtmf) {
        this.dtmf = dtmf;
    }

    protected void setFormat(int payloadID, Format format) {
        this.mainstream = payloadID;
        this.jitterBuffer.setFormat(format);
        this.formats.clear();
        this.formats.add(format);
        for (Codec c : this.rtpSocket.codecs) {
            if (!c.getSupportedInputFormat().matches(format)) continue;
            this.formats.add(c.getSupportedOutputFormat());
        }
    }

    public Format[] getFormats() {
        if (this.rtpSocket.getFormat() == null) {
            return new Format[0];
        }
        Format[] fmts = new Format[this.formats.size()];
        this.formats.toArray(fmts);
        return fmts;
    }

    public void setPreffered(Format format) {
        super.setPreffered(format);
        if (format == null) {
            return;
        }
        this.dtmfConverter.setPreffered(format);
        if (format.matches(this.rtpSocket.getFormat())) {
            this.codec = null;
            return;
        }
        for (Codec c : this.rtpSocket.codecs) {
            if (!c.getSupportedOutputFormat().matches(format)) continue;
            this.codec = c;
            return;
        }
    }

    public double getInterArrivalJitter() {
        return this.jitterBuffer.getInterArrivalJitter();
    }

    public double getMaxJitter() {
        return this.jitterBuffer.getMaxJitter();
    }

    public void evolve(Buffer buffer, long timestamp) {
        RtpPacket packet = this.jitterBuffer.read(timestamp);
        if (packet == null) {
            buffer.setFlags(2);
            buffer.setDuration((long)this.rtpSocket.getPeriod());
        } else if (packet.getPayloadType() == this.mainstream) {
            buffer.setData(packet.getPayload());
            buffer.setOffset(0);
            buffer.setTimeStamp(timestamp);
            buffer.setLength(packet.getPayload().length);
            if (packet.getDuration() >= 0L) {
                buffer.setDuration(packet.getDuration());
            } else {
                buffer.setDuration((long)this.rtpSocket.getPeriod());
            }
            buffer.setFormat(this.format);
            if (packet.getMarker()) {
                buffer.setFlags(buffer.getFlags() | 0x10);
            }
            if (this.codec != null) {
                this.codec.process(buffer);
            }
        } else if (packet.getPayloadType() == this.dtmf) {
            this.dtmfConverter.process(packet, buffer);
            buffer.setTimeStamp(timestamp);
        } else {
            System.out.println("Unexpected packet ");
            buffer.setFlags(2);
            buffer.setDuration((long)this.rtpSocket.getPeriod());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Receive " + buffer));
        }
        this.byteCount += (long)(buffer.getLength() + 12);
    }

    protected void reset() {
        this.mainstream = -1;
        this.formats.clear();
        this.byteCount = 0L;
        this.jitterBuffer = new JitterBuffer(this.jitter);
        this.jitterBuffer.setClock(this.rtpSocket.getClock());
    }
}

