/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.RtpFactory;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.RtpSocket;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.TimerTask;

public class Receiver
implements Task {
    private Selector selector;
    private int bufferSize = 8196;
    private ByteBuffer readBuffer = ByteBuffer.allocateDirect(this.bufferSize);
    private volatile boolean started;
    private RtpFactory factory;
    private Logger logger = Logger.getLogger(Receiver.class);
    private TimerTask worker;

    public Receiver(RtpFactory factory) throws IOException {
        this.factory = factory;
        this.selector = SelectorProvider.provider().openSelector();
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void start() {
        this.started = true;
        this.worker = this.factory.getTimer().sync((Task)this);
    }

    public void stop() {
        this.worker.cancel();
        this.started = false;
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cancel() {
        this.stop();
    }

    public boolean isActive() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int perform() {
        try {
            this.selector.selectNow();
            Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
            while (keys.hasNext()) {
                SelectionKey key = keys.next();
                keys.remove();
                DatagramChannel channel = (DatagramChannel)key.channel();
                RtpSocket socket = (RtpSocket)key.attachment();
                if (!key.isReadable()) continue;
                int len = 1;
                while (len > 0 && !socket.isClosed()) {
                    len = channel.read(this.readBuffer);
                    this.readBuffer.flip();
                    if (len > 0) {
                        RtpPacket rtpPacket = new RtpPacket(this.readBuffer);
                        socket.receive(rtpPacket);
                    }
                    this.readBuffer.clear();
                }
            }
            this.factory.register();
        }
        catch (IOException iOException) {}
        finally {
            return 20;
        }
    }

    private String convert(String msg) {
        try {
            byte[] data = msg.getBytes("Cp1251");
            return new String(data, "Cp866");
        }
        catch (Exception e) {
            return null;
        }
    }
}

