/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.Serializable;
import java.nio.ByteBuffer;

public class RtpPacket
implements Serializable {
    private int version = 2;
    private boolean padding = false;
    private boolean extensions = false;
    private int cc = 0;
    private volatile boolean marker = false;
    private int payloadType;
    private int seqNumber;
    private long timestamp;
    private long ssrc;
    private byte[] payload;
    private int offset = 0;
    private int length = 0;
    private long time;
    private long duration = -1L;
    private boolean isValid = false;
    private byte[] buff;

    public RtpPacket(ByteBuffer readerBuffer) {
        int len = readerBuffer.limit();
        this.buff = new byte[len];
        readerBuffer.get(this.buff, 0, len);
        int b = this.buff[0] & 0xFF;
        this.version = (b & 0xC0) >> 6;
        this.padding = (b & 0x20) == 32;
        this.extensions = (b & 0x10) == 16;
        this.cc = b & 0xF;
        b = this.buff[1] & 0xFF;
        this.marker = (b & 0x80) == 128;
        this.payloadType = b & 0x7F;
        this.seqNumber = (this.buff[2] & 0xFF) << 8;
        this.seqNumber |= this.buff[3] & 0xFF;
        this.timestamp |= (long)(this.buff[4] & 0xFF);
        this.timestamp <<= 8;
        this.timestamp |= (long)(this.buff[5] & 0xFF);
        this.timestamp <<= 8;
        this.timestamp |= (long)(this.buff[6] & 0xFF);
        this.timestamp <<= 8;
        this.timestamp |= (long)(this.buff[7] & 0xFF);
        this.ssrc = this.buff[8] & 0xFF;
        this.ssrc <<= 8;
        this.ssrc |= (long)(this.buff[9] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(this.buff[10] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(this.buff[11] & 0xFF);
        this.payload = new byte[len - 12];
        System.arraycopy(this.buff, 12, this.payload, 0, this.payload.length);
    }

    public RtpPacket(byte payloadType, int seqNumber, int timestamp, long ssrc, byte[] payload) {
        this.payloadType = payloadType;
        this.payload = payload;
        this.seqNumber = seqNumber;
        this.timestamp = timestamp;
        this.ssrc = ssrc;
        this.offset = 0;
        this.length = payload.length;
    }

    public RtpPacket(boolean marker, byte payloadType, int seqNumber, int timestamp, long ssrc, byte[] payload, int offset, int length) {
        this.marker = marker;
        this.payloadType = payloadType;
        this.payload = payload;
        this.seqNumber = seqNumber;
        this.timestamp = timestamp;
        this.ssrc = ssrc;
        this.offset = offset;
        this.length = length;
        this.buff = new byte[payload.length + 12];
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean getMarker() {
        return this.marker;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public byte[] toByteArray() {
        this.buff[0] = (byte)(this.version << 6);
        if (this.padding) {
            this.buff[0] = (byte)(this.buff[0] | 0x20);
        }
        if (this.extensions) {
            this.buff[0] = (byte)(this.buff[0] | 0x10);
        }
        this.buff[0] = (byte)(this.buff[0] | this.cc & 0xF);
        this.buff[1] = (byte)this.payloadType;
        if (this.marker) {
            System.out.println("Set marker " + this.marker);
            this.buff[1] = (byte)(this.buff[1] | 0x80);
        }
        this.buff[2] = (byte)((this.seqNumber & 0xFF00) >> 8);
        this.buff[3] = (byte)(this.seqNumber & 0xFF);
        this.buff[4] = (byte)((this.timestamp & 0xFFFFFFFFFF000000L) >> 24);
        this.buff[5] = (byte)((this.timestamp & 0xFF0000L) >> 16);
        this.buff[6] = (byte)((this.timestamp & 0xFF00L) >> 8);
        this.buff[7] = (byte)(this.timestamp & 0xFFL);
        this.buff[8] = (byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24);
        this.buff[9] = (byte)((this.ssrc & 0xFF0000L) >> 16);
        this.buff[10] = (byte)((this.ssrc & 0xFF00L) >> 8);
        this.buff[11] = (byte)(this.ssrc & 0xFFL);
        System.arraycopy(this.payload, this.offset, this.buff, 12, this.length);
        return this.buff;
    }

    public String toString() {
        return "RTP Packet[marker=" + this.marker + ", seq=" + this.seqNumber + ", timestamp=" + this.timestamp + ", payload_size=" + this.payload.length + ", payload=" + this.payloadType + "]";
    }

    public int getVersion() {
        return this.version;
    }

    public int getContributingSource() {
        return this.cc;
    }

    public boolean isPadding() {
        return this.padding;
    }

    public boolean isExtensions() {
        return this.extensions;
    }

    public long getSyncSource() {
        return this.ssrc;
    }
}

