/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.rtp.ReceiveStream;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpFactory;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.RtpSocketListener;
import org.mobicents.media.server.impl.rtp.SendStream;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.clock.Timer;
import org.mobicents.media.server.spi.dsp.Codec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtpSocket {
    protected MediaType media;
    private DatagramSocket socket;
    private DatagramChannel channel;
    private String localAddress;
    protected InetSocketAddress remoteAddress = null;
    private int jitter = 60;
    private ReceiveStream receiveStream;
    private SendStream sendStream;
    protected Timer timer;
    private RtpFactory factory = null;
    private RtpSocketListener listener;
    private int period = 20;
    private AVProfile avProfile = new AVProfile();
    protected Collection<Codec> codecs;
    private RtpClock clock;
    private Format format;
    private int payloadId;
    private SelectionKey selection;
    protected boolean registered = false;
    private ByteBuffer sendBuffer = ByteBuffer.allocateDirect(8192);
    private int packetsSent;
    private int packetsReceived;
    private volatile boolean isClosed = false;
    private int prefferedPort;

    public RtpSocket(RtpFactory factory, Collection<Codec> codecs, MediaType media) throws IOException, ResourceUnavailableException {
        this.media = media;
        this.clock = factory.getClock(media);
        this.factory = factory;
        this.timer = factory.getTimer();
        this.codecs = codecs;
        this.avProfile = factory.getAVProfile().clone();
        this.jitter = factory.getJitter();
        this.prefferedPort = factory.getNextPort();
        this.sendStream = new SendStream(this, this.avProfile);
        this.receiveStream = new ReceiveStream(this, factory.getJitter(), this.avProfile);
        this.localAddress = factory.getBindAddress();
    }

    private void openChannel() throws IOException {
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.socket = this.channel.socket();
    }

    public void bind() throws IOException, ResourceUnavailableException {
        this.isClosed = false;
        this.openChannel();
        while (!this.socket.isBound()) {
            try {
                InetSocketAddress address = new InetSocketAddress(this.factory.getBindAddress(), this.prefferedPort);
                this.socket.bind(address);
            }
            catch (SocketException e) {
                this.prefferedPort = this.factory.getNextPort();
            }
        }
        if (!this.socket.isBound()) {
            this.channel.close();
            throw new ResourceUnavailableException();
        }
    }

    protected void register(Selector selector) throws ClosedChannelException {
        this.selection = this.channel.register(selector, 1, this);
        this.registered = true;
    }

    public DatagramSocket getDatagramSocket() {
        return this.socket;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    protected Timer getTimer() {
        return this.timer;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getPeriod() {
        return this.period;
    }

    public Collection<Codec> getCodecs() {
        return this.codecs;
    }

    public void setFormat(int payloadId, Format format) {
        if (payloadId < 0) {
            throw new IllegalArgumentException("Illegal payload number");
        }
        if (format == null) {
            throw new IllegalArgumentException("Format can not be null");
        }
        this.payloadId = payloadId;
        this.format = format;
        this.sendStream.setFormat(payloadId, format);
        this.receiveStream.setFormat(payloadId, format);
    }

    public void setDtmfPayload(int dtmf) {
        this.receiveStream.setDtmf(dtmf);
        this.sendStream.setDtmf(dtmf);
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalPort() {
        return this.prefferedPort;
    }

    public int getJitter() {
        return this.jitter;
    }

    public void setJitter(int jitter) {
        this.jitter = jitter;
    }

    public void setClock(RtpClock clock) {
        this.clock = clock;
    }

    public RtpClock getClock() {
        return this.clock;
    }

    public ReceiveStream getReceiveStream() {
        return this.receiveStream;
    }

    public AVProfile getAVProfile() {
        return this.avProfile;
    }

    public int getPacketsReceived() {
        return this.packetsReceived;
    }

    public int getPacketsSent() {
        return this.packetsSent;
    }

    public void release() {
        System.out.println("Release socket");
        this.isClosed = true;
        if (this.selection != null) {
            this.selection.cancel();
        }
        this.receiveStream.reset();
        this.sendStream.reset();
        this.format = null;
        this.payloadId = -1;
        this.packetsSent = 0;
        this.packetsReceived = 0;
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.socket != null) {
                this.socket.disconnect();
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public RtpSocketListener getListener() {
        return this.listener;
    }

    public void setListener(RtpSocketListener listener) {
        this.listener = listener;
    }

    public void setPeer(InetAddress address, int port) throws IOException {
        this.remoteAddress = new InetSocketAddress(address, port);
        this.channel.connect(this.remoteAddress);
        this.factory.registerQueue.offer(this);
    }

    public SendStream getSendStream() {
        return this.sendStream;
    }

    public void send(RtpPacket packet) throws IOException {
        byte[] p = packet.toByteArray();
        this.send(p);
    }

    public void send(byte[] packet) throws IOException {
        this.sendBuffer.clear();
        this.sendBuffer.rewind();
        this.sendBuffer.put(packet);
        this.sendBuffer.flip();
        this.channel.write(this.sendBuffer);
        ++this.packetsSent;
    }

    public void receive(RtpPacket rtpPacket) {
        this.receiveStream.process(rtpPacket);
        ++this.packetsReceived;
    }

    protected void notify(Exception e) {
        if (this.listener != null) {
            this.listener.error(e);
        }
    }

    public long getBytesReceived() {
        return this.receiveStream.byteCount;
    }

    public long getBytesSent() {
        return this.sendStream.byteCount;
    }
}

