/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.clock;

import org.mobicents.media.Format;
import org.mobicents.media.format.VideoFormat;
import org.mobicents.media.server.impl.rtp.RtpClock;

public class VideoClock
extends RtpClock {
    private double rtpUnit;
    private double frameDuration;

    public void setFormat(Format format) {
        super.setFormat(format);
        VideoFormat fmt = (VideoFormat)format;
        this.frameDuration = 1000 / fmt.getFrameRate();
        this.rtpUnit = fmt.getClockRate() / fmt.getFrameRate();
    }

    public long getTime(long timestamp) {
        return (long)((double)timestamp / this.rtpUnit * this.frameDuration);
    }

    public long getTimestamp(long time) {
        return (long)((double)time / this.frameDuration * this.rtpUnit);
    }
}

