/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.rfc2833;

import java.util.ArrayList;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.dsp.audio.gsm.DecoderFactory;
import org.mobicents.media.server.impl.dsp.audio.speex.EncoderFactory;
import org.mobicents.media.server.impl.resource.dtmf.DtmfEvent;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.CodecFactory;

public class DtmfConverter {
    private static final AudioFormat LINEAR_AUDIO = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private double dt = 1.0 / LINEAR_AUDIO.getSampleRate();
    private short A = (short)16383;
    private int volume = 0;
    private int f1;
    private int f2;
    private double time = 0.0;
    private long rtpTime = 0L;
    private RtpClock clock;
    public static final String[] TONE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "#", "A", "B", "C", "D"};
    public static final String[][] events = new String[][]{{"1", "2", "3", "A"}, {"4", "5", "6", "B"}, {"7", "8", "9", "C"}, {"*", "0", "#", "D"}};
    private int[] lowFreq = new int[]{697, 770, 852, 941};
    private int[] highFreq = new int[]{1209, 1336, 1477, 1633};
    private Codec codec;
    private static final ArrayList<CodecFactory> codecFactories = new ArrayList();

    public void setClock(RtpClock clock) {
        this.clock = clock;
    }

    private short getValue(double t) {
        return (short)((double)this.A * (Math.sin(Math.PI * 2 * (double)this.f1 * t) + Math.sin(Math.PI * 2 * (double)this.f2 * t)));
    }

    public void setPreffered(Format fmt) {
        this.codec = this.selectCodec(fmt);
    }

    private Codec selectCodec(Format f) {
        for (CodecFactory factory : codecFactories) {
            if (!factory.getSupportedOutputFormat().matches(f) || !factory.getSupportedInputFormat().matches((Format)Codec.LINEAR_AUDIO)) continue;
            return factory.getCodec();
        }
        return null;
    }

    public void process(RtpPacket packet, Buffer buffer) {
        if (packet.getMarker()) {
            this.time = 0.0;
            this.rtpTime = 0L;
        }
        byte[] data = packet.getPayload();
        String digit = TONE[data[0]];
        this.volume = data[1] & 0x3F;
        int duration = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        this.rtpTime = duration;
        int d = (int)((double)this.clock.getTime(this.rtpTime) - this.time * 1000.0);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!events[i][j].equalsIgnoreCase(digit)) continue;
                this.f1 = this.lowFreq[i];
                this.f2 = this.highFreq[j];
            }
        }
        int k = 0;
        int frameSize = 160;
        data = new byte[2 * frameSize];
        for (int i = 0; i < frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        buffer.setHeader((Object)new DtmfEvent(null, DtmfEvent.getId(digit), this.volume));
        buffer.setData(data);
        buffer.setOffset(0);
        buffer.setLength(320);
        buffer.setFormat((Format)LINEAR_AUDIO);
        buffer.setDuration((long)d);
        this.time += (double)d / 1000.0;
        if (this.codec != null) {
            this.codec.process(buffer);
        }
    }

    static {
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.alaw.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.alaw.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.EncoderFactory());
        codecFactories.add(new DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.gsm.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.speex.DecoderFactory());
        codecFactories.add(new EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g729.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g729.EncoderFactory());
    }
}

