/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import org.mobicents.media.Format;
import org.mobicents.media.format.VideoFormat;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.impl.rtp.sdp.FormatParser;

public class VideoFormatParser
implements FormatParser {
    public Format getFormat(int payload) {
        return AVPROFILE.getVideoFormat(payload);
    }

    public boolean parse(String rtpmap, int[] payloads, Format[] formats, int count) {
        int index;
        int pos = rtpmap.indexOf(58);
        int pos1 = rtpmap.indexOf(32, pos);
        int payload = Integer.parseInt(rtpmap.substring(pos + 1, pos1));
        for (index = 0; index < count && payloads[index] != payload; ++index) {
        }
        pos = rtpmap.indexOf(47, pos1);
        String encoding = rtpmap.substring(pos1 + 1, pos);
        double clockRate = Double.parseDouble(rtpmap.substring(pos + 1, rtpmap.length()));
        formats[index] = new VideoFormat(encoding, 25.0f, (int)clockRate);
        payloads[index] = payload;
        return index == count;
    }

    public void write(StringBuffer buff, int p, Format f) {
        VideoFormat fmt = (VideoFormat)f;
        String encName = fmt.getEncoding().toLowerCase();
        buff.append("a=rtpmap:");
        buff.append(p);
        buff.append(" ");
        buff.append(encName);
        buff.append("/");
        buff.append(fmt.getClockRate());
        if (f.equals((Object)AVProfile.H263)) {
            buff.append("\na=fmtp:" + p + " QCIF=2 CIF=3 MaxBR=1960");
        }
    }
}

