/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.mobicents.media.Component;
import org.mobicents.media.Format;
import org.mobicents.media.Inlet;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.Outlet;
import org.mobicents.media.server.impl.resource.Proxy;
import org.mobicents.media.server.resource.Pipe;
import org.mobicents.media.server.resource.UnknownComponentException;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel {
    protected HashMap<String, MediaSource> sources;
    protected HashMap<String, MediaSink> sinks;
    protected HashMap<String, Inlet> inlets;
    protected HashMap<String, Outlet> outlets;
    private List<Pipe> pipes = new ArrayList<Pipe>();
    private Proxy localPipe = new Proxy("Channel");
    private MediaSink intake;
    private MediaSource exhaust;
    private Endpoint endpoint;
    private Connection connection;
    private Channel txChannel;
    private Channel rxChannel;
    private HashMap<String, ? extends Component> components;

    protected Channel(HashMap<String, MediaSource> sources, HashMap<String, MediaSink> sinks, HashMap<String, Inlet> inlets, HashMap<String, Outlet> outlets) {
        this.sources = sources;
        this.sinks = sinks;
        this.inlets = inlets;
        this.outlets = outlets;
        this.intake = this.localPipe.getInput();
        this.exhaust = this.localPipe.getOutput();
    }

    protected Channel(HashMap<String, ? extends Component> components) {
        this.components = components;
    }

    public Format[] getFormats() {
        return null;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setEndpoint(Endpoint endpoint) {
        Collection<MediaSource> list = this.sources.values();
        for (MediaSource s : list) {
            s.setEndpoint(endpoint);
        }
        Collection<MediaSink> list1 = this.sinks.values();
        for (MediaSink s : list1) {
            s.setEndpoint(endpoint);
        }
        Collection<Inlet> list2 = this.inlets.values();
        for (Inlet s : list2) {
            s.setEndpoint(endpoint);
        }
        Collection<Outlet> list3 = this.outlets.values();
        for (Outlet s : list3) {
            s.setEndpoint(endpoint);
        }
        this.intake.setEndpoint(endpoint);
        this.exhaust.setEndpoint(endpoint);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        Collection<MediaSource> list = this.sources.values();
        for (MediaSource s : list) {
            s.setConnection(connection);
        }
        Collection<MediaSink> list1 = this.sinks.values();
        for (MediaSink s : list1) {
            s.setConnection(connection);
        }
        Collection<Inlet> list2 = this.inlets.values();
        for (Inlet s : list2) {
            s.setConnection(connection);
        }
        Collection<Outlet> list3 = this.outlets.values();
        for (Outlet s : list3) {
            s.setConnection(connection);
        }
        this.intake.setConnection(connection);
        this.exhaust.setConnection(connection);
    }

    public void start() {
        for (Pipe pipe : this.pipes) {
            pipe.start();
        }
        this.intake.start();
        this.exhaust.start();
    }

    public void stop() {
        for (Pipe pipe : this.pipes) {
            pipe.stop();
        }
        Collection<MediaSource> list = this.sources.values();
        for (MediaSource s : list) {
            s.stop();
        }
        Collection<MediaSink> list2 = this.sinks.values();
        for (MediaSink s : list2) {
            s.stop();
        }
        Collection<Inlet> list3 = this.inlets.values();
        for (Inlet s : list3) {
            s.getInput().stop();
        }
        Collection<Outlet> list4 = this.outlets.values();
        for (Outlet s : list4) {
            s.getOutput().stop();
        }
        this.intake.stop();
        this.exhaust.stop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openPipe(Pipe pipe, String inlet, String outlet) throws UnknownComponentException {
        if (inlet == null && outlet != null) {
            if (!this.sinks.containsKey(outlet)) throw new UnknownComponentException(outlet);
            this.intake = this.sinks.get(outlet);
            return;
        } else if (inlet != null && outlet == null) {
            if (!this.sources.containsKey(inlet)) throw new UnknownComponentException(inlet);
            this.exhaust = this.sources.get(inlet);
            return;
        } else {
            pipe.open(inlet, outlet);
            this.pipes.add(pipe);
        }
    }

    public void closePipe(Pipe pipe) {
        pipe.close();
    }

    public Format[] getInputFormats() {
        return this.intake.getFormats();
    }

    public Format[] getOutputFormats() {
        return this.exhaust.getFormats();
    }

    public Format[] connect(MediaSink sink) {
        if (this.rxChannel != null) {
            throw new IllegalStateException("Channel is connected as source for other channel");
        }
        this.exhaust.connect(sink);
        return null;
    }

    public void disconnect(MediaSink sink) {
        if (this.rxChannel != null) {
            throw new IllegalStateException("Channel is connected as source for other channel");
        }
        this.exhaust.disconnect(sink);
    }

    public Format[] connect(MediaSource source) {
        if (this.txChannel != null) {
            throw new IllegalStateException("Channel is connected as sink for other channel");
        }
        this.intake.connect(source);
        return null;
    }

    public void disconnect(MediaSource source) {
        if (this.txChannel != null) {
            throw new IllegalStateException("Channel is connected as sink for other channel");
        }
        this.intake.disconnect(source);
    }

    public void connect(Channel rxChannel) {
        this.rxChannel = rxChannel;
        rxChannel.txChannel = this;
        this.exhaust.connect(rxChannel.intake);
    }

    public void disconnect(Channel channel) {
        if (this.rxChannel != null && this.rxChannel == channel) {
            this.exhaust.disconnect(this.rxChannel.intake);
            this.rxChannel.txChannel = null;
            this.rxChannel = null;
        } else if (this.txChannel != null && this.txChannel == channel) {
            this.intake.disconnect(this.txChannel.exhaust);
            this.txChannel.rxChannel = null;
            this.txChannel = null;
        } else {
            throw new IllegalArgumentException("Channels " + this + " and " + channel + " was never connected");
        }
    }

    public Component getComponent(String name) {
        if (this.inlets.containsKey(name)) {
            return (Component)this.inlets.get(name);
        }
        if (this.outlets.containsKey(name)) {
            return (Component)this.outlets.get(name);
        }
        if (this.sources.containsKey(name)) {
            return (Component)this.sources.get(name);
        }
        if (this.sinks.containsKey(name)) {
            return (Component)this.sinks.get(name);
        }
        return null;
    }

    public Component getComponent(Class _interface) {
        Component c;
        for (MediaSource src : this.sources.values()) {
            c = (Component)src.getInterface(_interface);
            if (c == null) continue;
            return src;
        }
        for (MediaSink sink : this.sinks.values()) {
            c = (Component)sink.getInterface(_interface);
            if (c == null) continue;
            return sink;
        }
        return null;
    }

    public void close() {
        for (Pipe pipe : this.pipes) {
            this.closePipe(pipe);
        }
        this.pipes.clear();
        this.sources.clear();
        this.sinks.clear();
        this.outlets.clear();
        this.inlets.clear();
    }

    private Format[] getSubset(Format[] f1, Format[] f2) {
        ArrayList<Format> list = new ArrayList<Format>();
        for (int i = 0; i < f1.length; ++i) {
            for (int j = 0; j < f2.length; ++j) {
                if (!f1[i].matches(f2[j])) continue;
                list.add(f1[i]);
            }
        }
        Format[] f = new Format[list.size()];
        list.toArray(f);
        return f;
    }

    public long getPacketsTransmitted() {
        return this.exhaust.getPacketsTransmitted();
    }

    public long getBytesTransmitted() {
        return this.exhaust.getBytesTransmitted();
    }

    public String toString() {
        String enpName = this.getEndpoint() != null ? this.getEndpoint().getLocalName() : "unknown";
        String conID = this.getConnection() != null ? this.getConnection().getId() : " unknown";
        return "Channel[endpoint=" + enpName + " connection=" + conID + "]";
    }
}

