/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.mobicents.media.Component;
import org.mobicents.media.ComponentFactory;
import org.mobicents.media.Inlet;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.Outlet;
import org.mobicents.media.server.resource.Channel;
import org.mobicents.media.server.resource.PipeFactory;
import org.mobicents.media.server.resource.UnknownComponentException;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.MultimediaSink;
import org.mobicents.media.server.spi.MultimediaSource;
import org.mobicents.media.server.spi.ResourceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelFactory {
    private List<PipeFactory> pipes;
    private List<ComponentFactory> factories;
    private MediaType mediaType;
    private volatile boolean started = false;
    private static final Logger logger = Logger.getLogger(ChannelFactory.class);

    public Channel newInstance(Endpoint endpoint, MediaType media) throws ResourceUnavailableException {
        if (!this.started) {
            throw new IllegalStateException("Factory is not started");
        }
        return this.createNewChannel(endpoint, media);
    }

    private Channel createNewChannel(Endpoint endpoint, MediaType media) throws ResourceUnavailableException {
        HashMap<String, MediaSource> sources = new HashMap<String, MediaSource>();
        HashMap<String, MediaSink> sinks = new HashMap<String, MediaSink>();
        HashMap<String, Inlet> inlets = new HashMap<String, Inlet>();
        HashMap<String, Outlet> outlets = new HashMap<String, Outlet>();
        for (ComponentFactory factory : this.factories) {
            Collection supportedTypes;
            MultimediaSource ms;
            Component component = factory.newInstance(endpoint);
            if (component instanceof MultimediaSource) {
                ms = (MultimediaSource)component;
                supportedTypes = ms.getMediaTypes();
                if (!supportedTypes.contains(media)) continue;
                component = ms.getMediaSource(media);
            }
            if (component instanceof MultimediaSink) {
                ms = (MultimediaSink)component;
                supportedTypes = ms.getMediaTypes();
                if (!supportedTypes.contains(media)) continue;
                component = ms.getMediaSink(media);
            }
            if (component instanceof MediaSink) {
                sinks.put(component.getName(), (MediaSink)component);
            }
            if (component instanceof MediaSource) {
                sources.put(component.getName(), (MediaSource)component);
            }
            if (component instanceof Inlet) {
                sinks.put(component.getName(), ((Inlet)component).getInput());
                inlets.put(component.getName(), (Inlet)component);
            }
            if (!(component instanceof Outlet)) continue;
            sources.put(component.getName(), ((Outlet)component).getOutput());
            outlets.put(component.getName(), (Outlet)component);
        }
        Channel channel = new Channel(sources, sinks, inlets, outlets);
        for (PipeFactory pipeFactory : this.pipes) {
            try {
                pipeFactory.openPipe(channel);
            }
            catch (UnknownComponentException e) {
                throw new ResourceUnavailableException((Throwable)e);
            }
        }
        return channel;
    }

    public void setPipes(List<PipeFactory> pipes) {
        this.pipes = pipes;
    }

    public List getPipes() {
        return this.pipes;
    }

    public List getComponents() {
        return this.factories;
    }

    public void setComponents(List components) {
        this.factories = components;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void start() throws Exception {
        this.started = true;
        if (this.factories == null) {
            this.factories = new ArrayList<ComponentFactory>();
        }
        if (this.pipes == null) {
            this.pipes = new ArrayList<PipeFactory>();
        }
    }

    public void stop() {
        this.started = false;
        this.pipes.clear();
        this.factories.clear();
    }
}

