/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.resource;

import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.resource.Channel;
import org.mobicents.media.server.resource.UnknownComponentException;
import org.mobicents.media.server.spi.Valve;

public class Pipe {
    private MediaSink sink;
    private MediaSource source;
    private Valve valve = Valve.CLOSE;
    private Channel channel;

    protected Pipe(Channel channel) {
        this.channel = channel;
    }

    public Valve getValve() {
        return this.valve;
    }

    public void setValve(Valve valve) {
        this.valve = valve;
    }

    public void open(String inletName, String outletName) throws UnknownComponentException {
        if (!this.channel.sources.containsKey(inletName)) {
            throw new UnknownComponentException(inletName + " \n--> " + this.channel.sources + " \n--> " + this.channel.sinks);
        }
        this.source = this.channel.sources.get(inletName);
        if (!this.channel.sinks.containsKey(outletName)) {
            this.source = null;
            throw new UnknownComponentException(outletName + " --> " + this.channel.sinks);
        }
        this.sink = this.channel.sinks.get(outletName);
        this.sink.connect(this.source);
    }

    public void start() {
        if (this.valve == Valve.OPEN) {
            if (this.sink != null) {
                this.sink.start();
            }
            if (this.source != null) {
                this.source.start();
            }
        }
    }

    public void stop() {
        if (this.sink != null) {
            this.sink.stop();
        }
        if (this.source != null) {
            this.source.stop();
        }
    }

    public void close() {
        if (this.sink != null && this.source != null) {
            this.sink.disconnect(this.source);
            this.sink = null;
            this.source = null;
        }
    }
}

