/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.naming.InnerNamingService;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointFactory;
import org.mobicents.media.server.spi.ResourceUnavailableException;

public class EndpointManager {
    private ArrayList<EndpointFactory> endpoints = new ArrayList();
    private InnerNamingService namingService;
    private Logger logger = Logger.getLogger(EndpointManager.class);

    public void setNamingService(InnerNamingService namingService) throws ResourceUnavailableException {
        this.namingService = namingService;
    }

    public void activate() throws ResourceUnavailableException {
        for (EndpointFactory factory : this.endpoints) {
            Collection list = factory.install();
            for (Endpoint e : list) {
                e.start();
                this.logger.info((Object)("Started endpoint " + e.getLocalName()));
                this.namingService.addEndpoint(e);
            }
        }
    }

    public void addEndpoint(EndpointFactory endpoint) throws ResourceUnavailableException {
        this.endpoints.add(endpoint);
        this.logger.info((Object)("Installed Endpoint Factory : " + endpoint));
    }

    public void removeEndpoint(EndpointFactory endpoint) {
    }
}

