/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.clock.Scheduler;
import org.mobicents.media.server.impl.naming.InnerNamingService;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointFactory;
import org.mobicents.media.server.spi.MediaServer;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.clock.Timer;
import org.mobicents.media.server.spi.rtp.RtpListener;
import org.mobicents.media.server.spi.rtp.RtpManager;

public class Server
implements MediaServer {
    public static final Scheduler scheduler = new Scheduler();
    private InnerNamingService namingService;
    private RtpManager rtpFactory;
    private RtpErrorHandler rtpErrorHandler;
    private ArrayList<EndpointFactory> factories = new ArrayList();
    private Logger logger = Logger.getLogger(Server.class);

    public Server() {
        this.rtpErrorHandler = new RtpErrorHandler();
        this.namingService = new InnerNamingService();
    }

    public void setTimer(Timer timer) {
        scheduler.setTimer(timer);
    }

    public void register(Endpoint endpoint) throws ResourceUnavailableException {
        this.namingService.addEndpoint(endpoint);
    }

    public RtpManager getRtpManager() {
        return this.rtpFactory;
    }

    public void setRtpManager(RtpManager rtpFactory) {
        this.rtpFactory = rtpFactory;
        rtpFactory.setListener((RtpListener)this.rtpErrorHandler);
    }

    public void addFactory(EndpointFactory factory) throws ResourceUnavailableException {
        this.factories.add(factory);
        factory.setRtpManager(this.rtpFactory);
        this.logger.info((Object)("Added factory " + factory));
        Collection list = factory.install();
        this.logger.info((Object)("Installing " + list.size() + "  endpoints"));
        for (Endpoint e : list) {
            try {
                e.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ResourceUnavailableException((Throwable)ex);
            }
            this.logger.info((Object)("Started endpoint " + e.getLocalName()));
            this.namingService.addEndpoint(e);
        }
    }

    public void removeFactory(EndpointFactory factory) {
        this.factories.remove(factory);
    }

    public void start() throws Exception {
        scheduler.start();
        this.logger.info((Object)"Starting media server");
        if (this.rtpFactory != null) {
            this.rtpFactory.start(System.currentTimeMillis());
        }
        this.logger.info((Object)"Started media server instance =======================");
    }

    public void stop() {
        scheduler.stop();
        this.logger.info((Object)"Stopped media server instance ");
    }

    private void restart() {
    }

    public Endpoint lookup(String name, boolean bussy) throws ResourceUnavailableException {
        return this.namingService.lookup(name, bussy);
    }

    public int getEndpointCount() {
        return this.namingService.getEndpointCount();
    }

    private class RtpErrorHandler
    implements RtpListener {
        private RtpErrorHandler() {
        }

        public void notify(Exception e) {
            Server.this.restart();
        }
    }
}

