/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.mobicents.media.Component;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.Server;
import org.mobicents.media.server.ConnectionFactory;
import org.mobicents.media.server.ConnectionImpl;
import org.mobicents.media.server.LocalConnectionImpl;
import org.mobicents.media.server.RtpConnectionImpl;
import org.mobicents.media.server.impl.clock.LocalTask;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointState;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.TooManyConnectionsException;
import org.mobicents.media.server.spi.rtp.RtpManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEndpointImpl
implements Endpoint {
    private String localName;
    private EndpointState state = EndpointState.READY;
    private LocalTask stateHandler;
    protected ConnectionFactory connectionFactory;
    protected RtpManager rtpFactory;
    private HashMap<MediaType, MediaSource> sources = new HashMap();
    private HashMap<MediaType, MediaSink> sinks = new HashMap();
    private ArrayList<MediaType> mediaTypes = new ArrayList();
    private ArrayList<Integer> index = new ArrayList();
    private int lastIndex = -1;
    private static final int _CONNECTION_TAB_SIZE = 10;
    private LocalConnectionImpl[] localConnections;
    private RtpConnectionImpl[] networkConnections;
    private Connection[] connections;
    private int count;
    protected ReentrantLock stateLock = new ReentrantLock();
    private final Logger logger = Logger.getLogger(BaseEndpointImpl.class);

    public BaseEndpointImpl(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public EndpointState getState() {
        return this.state;
    }

    public Collection<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    protected void setMediaTypes(Collection<MediaType> mediaTypes) {
        this.mediaTypes.addAll(mediaTypes);
    }

    public MediaSink getSink(MediaType media) {
        MediaSink sink = this.sinks.get(media);
        return sink;
    }

    protected void setSinks(HashMap<MediaType, MediaSink> sinks) {
        this.sinks.putAll(sinks);
    }

    public MediaSource getSource(MediaType media) {
        return this.sources.get(media);
    }

    protected void setSources(HashMap<MediaType, MediaSource> sources) {
        this.sources.putAll(sources);
    }

    public int getConnectionIndex() {
        return this.index.isEmpty() ? (this.lastIndex = this.lastIndex + 1) : this.index.remove(0);
    }

    public void start() throws ResourceUnavailableException {
        int i;
        this.networkConnections = new RtpConnectionImpl[10];
        this.localConnections = new LocalConnectionImpl[10];
        this.connections = new ConnectionImpl[10];
        for (i = 0; i < this.connections.length; ++i) {
            this.localConnections[i] = new LocalConnectionImpl(this, this.connectionFactory);
            this.setLifeTime(this.localConnections[i]);
        }
        if (this.rtpFactory != null) {
            for (i = 0; i < this.connections.length; ++i) {
                this.networkConnections[i] = new RtpConnectionImpl(this, this.connectionFactory, this.rtpFactory);
                this.setLifeTime(this.networkConnections[i]);
            }
        }
    }

    private void setLifeTime(Connection connection) {
        if (this.connectionFactory != null && this.connectionFactory.getConnectionStateManager() != null) {
            Hashtable<ConnectionState, Integer> connStateLifeTime = this.connectionFactory.getConnectionStateManager().getConnStateLifeTime();
            for (ConnectionState connState : connStateLifeTime.keySet()) {
                connection.getLifeTime()[connState.getCode()] = connStateLifeTime.get(connState);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("silence for state " + connState + " is " + connStateLifeTime.get(connState)));
            }
        }
    }

    public void stop() {
        this.logger.info((Object)("Stopped " + this.localName));
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setRtpManager(RtpManager rtpFactory) {
        this.rtpFactory = rtpFactory;
    }

    public RtpManager getRtpManager() {
        return this.rtpFactory;
    }

    public Collection<Connection> getConnections() {
        return null;
    }

    public String describe(MediaType mediaType) throws ResourceUnavailableException {
        String sdp = null;
        this.stateLock.lock();
        try {
            RtpConnectionImpl connection = null;
            for (int i = 0; i < this.networkConnections.length; ++i) {
                if (this.networkConnections[i].getState() != ConnectionState.NULL) continue;
                connection = this.networkConnections[i];
                break;
            }
            if (connection == null) {
                throw new ResourceUnavailableException("The limit of network connection is exeeded");
            }
            if (mediaType == null) {
                connection.join();
                sdp = connection.getLocalDescriptor();
                connection.close();
            } else {
                connection.join(mediaType);
                sdp = connection.getLocalDescriptor();
                connection.close(mediaType);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not create RTP connection", (Throwable)e);
            throw new ResourceUnavailableException(e.getMessage());
        }
        finally {
            this.stateLock.unlock();
        }
        return sdp;
    }

    public Connection createConnection() throws TooManyConnectionsException, ResourceUnavailableException {
        this.stateLock.lock();
        try {
            int i;
            RtpConnectionImpl connection = null;
            for (i = 0; i < this.networkConnections.length; ++i) {
                if (this.networkConnections[i].getState() != ConnectionState.NULL) continue;
                connection = this.networkConnections[i];
                break;
            }
            if (connection == null) {
                throw new ResourceUnavailableException("The limit of network connection is exeeded");
            }
            for (i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] != null) continue;
                connection.setIndex(i);
                System.out.println("Connection index=" + i);
                this.connections[i] = connection;
                break;
            }
            connection.join();
            connection.bind();
            connection.setStartTime(System.currentTimeMillis());
            this.stateHandler = Server.scheduler.execute(connection);
            ++this.count;
            this.state = EndpointState.BUSY;
            RtpConnectionImpl rtpConnectionImpl = connection;
            return rtpConnectionImpl;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not create RTP connection", (Throwable)e);
            throw new ResourceUnavailableException(e.getMessage());
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public Connection createLocalConnection() throws TooManyConnectionsException, ResourceUnavailableException {
        this.stateLock.lock();
        try {
            int i;
            ConnectionImpl connection = null;
            for (i = 0; i < this.localConnections.length; ++i) {
                if (this.localConnections[i].getState() != ConnectionState.NULL) continue;
                connection = this.localConnections[i];
                break;
            }
            if (connection == null) {
                throw new ResourceUnavailableException("The limit of network connection is exeeded");
            }
            for (i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] != null) continue;
                connection.setIndex(i);
                this.connections[i] = connection;
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info((Object)("Connection index: " + i + ", on endpoint: " + this.localName));
                break;
            }
            connection.join();
            ((LocalConnectionImpl)connection).bind();
            connection.setStartTime(System.currentTimeMillis());
            this.stateHandler = Server.scheduler.execute(connection);
            ++this.count;
            this.state = EndpointState.BUSY;
            ConnectionImpl connectionImpl = connection;
            return connectionImpl;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not create Local connection", (Throwable)e);
            throw new ResourceUnavailableException(e.getMessage());
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConnection(String connectionID) {
        this.stateLock.lock();
        try {
            ConnectionImpl connection = null;
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null || !((ConnectionImpl)this.connections[i]).getId().equals(connectionID)) continue;
                connection = (ConnectionImpl)this.connections[i];
                this.connections[i] = null;
                break;
            }
            if (connection != null) {
                connection.close();
                --this.count;
            }
            this.state = this.count > 0 ? EndpointState.BUSY : EndpointState.READY;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllConnections() {
        this.stateLock.lock();
        try {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                ((ConnectionImpl)this.connections[i]).close();
                this.connections[i] = null;
            }
            this.count = 0;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void addNotificationListener(NotificationListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeNotificationListener(NotificationListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Connection getConnection(String connectionID) {
        for (int i = 0; i < this.connections.length; ++i) {
            if (this.connections[i] == null || !this.connections[i].getId().equals(connectionID)) continue;
            return this.connections[i];
        }
        return null;
    }

    public Component getComponent(String name) {
        Collection<MediaSource> components = this.sources.values();
        for (MediaSource source : components) {
            if (!source.getName().matches(name)) continue;
            return source;
        }
        Collection<MediaSink> components2 = this.sinks.values();
        for (MediaSink sink : components2) {
            if (!sink.getName().matches(name)) continue;
            return sink;
        }
        return null;
    }

    public String getLocalAddress(String media) {
        return this.rtpFactory != null ? this.rtpFactory.getBindAddress() : "0.0.0.0";
    }

    public int getLocalPort(String media) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public abstract void unblock();

    public abstract void block();
}

