/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mobicents.media.Buffer;
import org.mobicents.media.Component;
import org.mobicents.media.ComponentFactory;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.ConnectionFactory;
import org.mobicents.media.server.VirtualEndpointImpl;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.naming.NameParser;
import org.mobicents.media.server.impl.naming.NameToken;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointFactory;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.MultimediaSink;
import org.mobicents.media.server.spi.MultimediaSource;
import org.mobicents.media.server.spi.ResourceGroup;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.rtp.RtpManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointFactoryImpl
implements EndpointFactory {
    private String localName;
    private Map<String, ComponentFactory> sourceFactory;
    private Map<String, ComponentFactory> sinkFactory;
    private ComponentFactory groupFactory;
    protected ConnectionFactory connectionFactory;
    protected RtpManager rtpFactory;
    private ArrayList<MediaType> mediaTypes = new ArrayList();
    private NameParser nameParser;
    private static final Logger logger = Logger.getLogger(EndpointFactoryImpl.class);

    public EndpointFactoryImpl() {
        this.nameParser = new NameParser();
    }

    public EndpointFactoryImpl(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public Collection<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public Collection<Endpoint> install() throws ResourceUnavailableException {
        ArrayList<Endpoint> list = new ArrayList<Endpoint>();
        Iterator<NameToken> tokens = this.nameParser.parse(this.localName).iterator();
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("");
        Collection<String> names = this.getNames(prefixes, tokens.next(), tokens);
        for (String name : names) {
            VirtualEndpointImpl enp = new VirtualEndpointImpl(name);
            HashMap<MediaType, MediaSource> sources = null;
            HashMap<MediaType, MediaSink> sinks = null;
            if (this.groupFactory != null) {
                ResourceGroup group = (ResourceGroup)this.groupFactory.newInstance((Endpoint)enp);
                sources = this.createSource(group, enp);
                sinks = this.createSink(group, enp);
            } else {
                sources = this.createSources(enp);
                sinks = this.createSinks(enp);
            }
            enp.setMediaTypes(this.mediaTypes);
            enp.setSources(sources);
            enp.setSinks(sinks);
            enp.setConnectionFactory(this.connectionFactory);
            enp.setRtpManager(this.rtpFactory);
            list.add(enp);
        }
        return list;
    }

    public void uninstall() {
    }

    protected Collection<String> getNames(Collection<String> prefixes, NameToken token, Iterator<NameToken> tokens) {
        ArrayList<String> list = new ArrayList<String>();
        if (!tokens.hasNext()) {
            while (token.hasMore()) {
                String s = token.next();
                for (String prefix : prefixes) {
                    list.add(prefix + "/" + s);
                }
            }
            return list;
        }
        ArrayList<String> newPrefixes = new ArrayList<String>();
        while (token.hasMore()) {
            String s = token.next();
            for (String prefix : prefixes) {
                newPrefixes.add(prefix + "/" + s);
            }
        }
        return this.getNames(newPrefixes, tokens.next(), tokens);
    }

    private MediaType[] getMediaTypes(String media) {
        if (media.equalsIgnoreCase("audio")) {
            return new MediaType[]{MediaType.AUDIO};
        }
        if (media.equals("video")) {
            return new MediaType[]{MediaType.VIDEO};
        }
        if (media.equals("*")) {
            return new MediaType[]{MediaType.AUDIO, MediaType.VIDEO};
        }
        throw new IllegalArgumentException("Unknown media type " + media);
    }

    private HashMap<MediaType, MediaSource> createSources(Endpoint endpoint) throws ResourceUnavailableException {
        HashMap<MediaType, MediaSource> sources = new HashMap<MediaType, MediaSource>();
        if (this.sourceFactory == null) {
            sources.put(MediaType.AUDIO, new VirtualSource("virtual.source"));
            if (!this.mediaTypes.contains(MediaType.AUDIO)) {
                this.mediaTypes.add(MediaType.AUDIO);
            }
            return sources;
        }
        Set<String> types = this.sourceFactory.keySet();
        for (String media : types) {
            ComponentFactory factory = this.sourceFactory.get(media);
            Component source = factory.newInstance(endpoint);
            source.setEndpoint(endpoint);
            MediaType[] list = this.getMediaTypes(media);
            for (int i = 0; i < list.length; ++i) {
                if (source instanceof MediaSource) {
                    sources.put(list[i], (MediaSource)source);
                } else if (source instanceof MultimediaSource) {
                    sources.put(list[i], ((MultimediaSource)source).getMediaSource(list[i]));
                } else {
                    logger.warn((Object)("Component " + source.toString() + " is neither instance of MediaSource or MultimediaSource"));
                }
                if (this.mediaTypes.contains(list[i])) continue;
                this.mediaTypes.add(list[i]);
            }
        }
        return sources;
    }

    private HashMap<MediaType, MediaSource> createSource(ResourceGroup group, Endpoint endpoint) {
        HashMap<MediaType, MediaSource> sources = new HashMap<MediaType, MediaSource>();
        Collection list = group.getMediaTypes();
        for (MediaType mediaType : list) {
            MediaSource source = group.getSource(mediaType);
            if (source == null) continue;
            source.setEndpoint(endpoint);
            sources.put(mediaType, source);
            if (this.mediaTypes.contains(mediaType)) continue;
            this.mediaTypes.add(mediaType);
        }
        return sources;
    }

    private HashMap<MediaType, MediaSink> createSinks(Endpoint endpoint) throws ResourceUnavailableException {
        HashMap<MediaType, MediaSink> sinks = new HashMap<MediaType, MediaSink>();
        if (this.sinkFactory == null) {
            sinks.put(MediaType.AUDIO, new VirtualSink("virtual.sink"));
            if (!this.mediaTypes.contains(MediaType.AUDIO)) {
                this.mediaTypes.add(MediaType.AUDIO);
            }
            return sinks;
        }
        Set<String> types = this.sinkFactory.keySet();
        for (String media : types) {
            ComponentFactory factory = this.sinkFactory.get(media);
            Component sink = factory.newInstance(endpoint);
            sink.setEndpoint(endpoint);
            MediaType[] list = this.getMediaTypes(media);
            for (int i = 0; i < list.length; ++i) {
                if (sink instanceof MediaSink) {
                    sinks.put(list[i], (MediaSink)sink);
                } else if (sink instanceof MultimediaSink) {
                    sinks.put(list[i], ((MultimediaSink)sink).getMediaSink(list[i]));
                } else {
                    logger.warn((Object)("Component " + sink.toString() + " is neither instance of MediaSink or MultimediaSink"));
                }
                if (this.mediaTypes.contains(list[i])) continue;
                this.mediaTypes.add(list[i]);
            }
        }
        return sinks;
    }

    private HashMap<MediaType, MediaSink> createSink(ResourceGroup group, Endpoint endpoint) {
        HashMap<MediaType, MediaSink> sinks = new HashMap<MediaType, MediaSink>();
        Collection list = group.getMediaTypes();
        for (MediaType mediaType : list) {
            MediaSink sink = group.getSink(mediaType);
            if (sink == null) continue;
            sink.setEndpoint(endpoint);
            sinks.put(mediaType, sink);
            if (this.mediaTypes.contains(mediaType)) continue;
            this.mediaTypes.add(mediaType);
        }
        return sinks;
    }

    public void setSourceFactory(Map<String, ComponentFactory> sourceFactory) {
        this.sourceFactory = sourceFactory;
    }

    public Map<String, ComponentFactory> getSourceFactory() {
        return this.sourceFactory;
    }

    public void setSinkFactory(Map<String, ComponentFactory> sinkFactory) {
        this.sinkFactory = sinkFactory;
    }

    public Map<String, ComponentFactory> getSinkFactory() {
        return this.sinkFactory;
    }

    public ComponentFactory getGroupFactory() {
        return this.groupFactory;
    }

    public void setGroupFactory(ComponentFactory groupFactory) {
        this.groupFactory = groupFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setRtpManager(RtpManager rtpFactory) {
        this.rtpFactory = rtpFactory;
    }

    public RtpManager getRtpManager() {
        return this.rtpFactory;
    }

    private class VirtualSource
    extends AbstractSource {
        public VirtualSource(String name) {
            super(name);
        }

        public void evolve(Buffer buffer, long timestamp) {
            buffer.setFlags(4);
            buffer.setDuration(20L);
        }

        public Format[] getFormats() {
            return new Format[]{Format.ANY};
        }
    }

    private class VirtualSink
    extends AbstractSink {
        public VirtualSink(String name) {
            super(name);
        }

        public Format[] getFormats() {
            return new Format[]{Format.ANY};
        }

        public boolean isAcceptable(Format format) {
            return true;
        }

        public void onMediaTransfer(Buffer buffer) throws IOException {
        }
    }
}

